/* DynamicFace.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.commands;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.pietschy.command.Face;
import org.pietschy.command.FaceId;
import org.pietschy.command.FaceManager;

/**
 * Implemenation of {@link Face} which propagates changes of properties in the parent
 * of the face to the face itself.
 */
class DynamicFace extends Face implements PropertyChangeListener {
    
    // copy of private field super.faceManager
    protected FaceManager faceManager;
    
    /** Default constructor */
    public DynamicFace(FaceId id, FaceManager manager) {
	super(id, manager);
	this.faceManager = manager;
    }
    
    private static final Set<String> notPropagated = new HashSet<String>();
    
    static {
	notPropagated.add("acceleratorInherited");
	notPropagated.add("iconTextGapInherited");
	notPropagated.add("extendsId");
    }
    
    public void propertyChange(PropertyChangeEvent evt) {
	FaceId extendsId = getExtendsId();
	if (extendsId != null) {
	    String name = evt.getPropertyName();
	    if (! notPropagated.contains(name))
		pcs.firePropertyChange(new PropertyChangeEvent(this,name,evt.getOldValue(),evt.getNewValue()));
	}
    }
    
    public void setExtendsId(FaceId extendsId) {
	if (getExtendsId() != extendsId) {
	    if (getExtendsId() != null)
		faceManager.get(getExtendsId()).removePropertyChangeListener(this);
	    super.setExtendsId(extendsId);
	    if (getExtendsId() != null)
		faceManager.get(getExtendsId()).addPropertyChangeListener(this);
	}
    }
    
}
    
