/* TableColumnDecoration.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.tables;

import java.awt.Component;
import java.awt.Graphics;

/**
 * Interface type for table column decorations that can be used with
 * tables of type {@link EnhancedTable}.
 *
 */
public interface TableColumnDecoration extends Cloneable {
    

    /**
     * Return the height of this decoration. The dimensions of a decoration
     * determine its position on the column header and the bounds in which
     * mouse events are fired.
     */
    public int getDecorationHeight ();
    
    /**
     * Return the width of this decoration. The dimensions of a decoration
     * determine its position on the column header and the bounds in which
     * mouse events are fired.
     */
    public int getDecorationWidth ();
    
    /**
     * Paint this decoration.
     */
    public void paintDecoration (Component c, Graphics g, int x, int y);
    
    /**
     * Signals that the mouse pointer entered the bounds
     * of this decoration.
     */
    public void mouseEntered ();
        
    /**
     * Signals that the mouse pointer exited the bounds
     * of this decoration.
     */
    public void mouseExited ();
    
    /**
     * Signals that the mouse button was pressed inside the bounds
     * of this decoration.
     */
    public void mousePressed ();
    
    /**
     * Signals that the mouse button was released after being pressed
     * inside the bounds of this decoration.
     */
    public void mouseReleased ();
    
    /**
     * Makes a copy of this object. This is typically implemented as
     * <code>(MyDecoration)super.clone()</code> where <code>MyDecoration</code>
     * is a class that implements this interface, surrounded by a try-catch
     * clause which caches the <code>CloneNotSupportedException</code>.
     */
    public TableColumnDecoration copy ();
    
    /**
     * Called to indicate that this decoration has been associated
     * with the given table column.
     * @param columnIndex Column index in the data model.
     */
    public void setColumnIndex (int columnIndex);
    
        
}
