/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Using locations.  */
#define YYLSP_NEEDED 1



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     INCLUDE = 258,
     PREPARE = 259,
     YPREPARE = 260,
     RESULT = 261,
     STATUS = 262,
     SIMPLE = 263,
     SINGLE = 264,
     STRUCT = 265,
     MULTIROW = 266,
     MULTISTRUCT = 267,
     INT = 268,
     LONG = 269,
     BINARY = 270,
     VARCHAR = 271,
     INTP = 272,
     LONGP = 273,
     BINARYP = 274,
     VARCHARP = 275,
     TOKEN = 276,
     PARAM = 277,
     SQL = 278,
     STRING = 279,
     CVAR = 280,
     INDENT = 281
   };
#endif
#define INCLUDE 258
#define PREPARE 259
#define YPREPARE 260
#define RESULT 261
#define STATUS 262
#define SIMPLE 263
#define SINGLE 264
#define STRUCT 265
#define MULTIROW 266
#define MULTISTRUCT 267
#define INT 268
#define LONG 269
#define BINARY 270
#define VARCHAR 271
#define INTP 272
#define LONGP 273
#define BINARYP 274
#define VARCHARP 275
#define TOKEN 276
#define PARAM 277
#define SQL 278
#define STRING 279
#define CVAR 280
#define INDENT 281




/* Copy the first part of user declarations.  */
#line 12 "yadac.y"

/******************************************************************************
 * I N C L U D E S ************************************************************
 ******************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>

#include "yadac.h"
#include "yadac.y.h"
#include "yadac.lex.h"

/******************************************************************************
 * D E F I N E S **************************************************************
 ******************************************************************************/

/* autonumber enumeration */
#define FLAG_AUTONUM		1

/******************************************************************************
 * M A C R O S ****************************************************************
 ******************************************************************************/

/* trace for debugging */
#ifdef DEBUG
# define TRACE(m...)	printf(m);
#else
# define TRACE(m...)
#endif

/******************************************************************************
 * I N T E R N A L   F U N C T I O N S ****************************************
 ******************************************************************************/

/******************************************************************************/
/** error handler
 */

static int yyerror(YYLTYPE *loc, yyscan_t scanner, yadac_t *tree, char *msg)
{
  printf("yadac_parse: %s\n", msg);
  printf("line: %i\n", yyget_lineno(scanner));
  return(-1);
}

/******************************************************************************/
/** free list of SQL chunks
 */

static void free_sql(yadac_line_t *line)
{
  int loop;


  if(!line)
    return;

  /* free all chunks */
  for(loop=0; line[loop].text; loop++)
    free(line[loop].text);

  free(line);
}

/******************************************************************************/
/** add parameter to parameter list
 * @return parameter list pointer on success
 */

static yadac_param_t* add_param(yadac_param_t *list, yadac_param_t param)
{
  int ctr = 0;
  yadac_param_t *new;


  TRACE("param: %u\n", (param - (INT - YADAC_INT)));

  /* count current parameters in list */
  while(list && list[ctr])
    ctr++;

  /* allocate space for new parameter */
  if(!(new = realloc(list, (sizeof(yadac_param_t) * (ctr + 2)))))
    {
    free(list);
    return(NULL);
    }

  /* append parameter */
  new[ctr++] = param;
  new[ctr] = 0;
  return(new);
}

/******************************************************************************/
/** add a token to token list
 * @return token list pointer on success
 */

static yadac_tlist_t* add_token(yadac_tlist_t *list, char *token)
{
  int ctr = list ? list->tokens : 0;
  yadac_tlist_t *new;


  TRACE("token: %s\n", token);

  /* allocate space for new token */
  if(!(new = realloc(list, sizeof(yadac_tlist_t) + sizeof(char *) * ctr)))
    {
    free(list);
    return(NULL);
    }

  /* append parameter */
  new->token[ctr] = token;
  new->tokens = ctr + 1;
  return(new);
}

/******************************************************************************/
/** add a struct definition
 * @return strct pointer on success
 */

static yadac_struct_t* add_struct(char *type, yadac_tlist_t *list)
{
  yadac_struct_t *new;


  TRACE("struct: %s\n", type);

  /* allocate space for new token */
  if(!(new = malloc(sizeof(yadac_struct_t))))
    return(NULL);

  /* append parameter */
  new->type = type;
  new->list = list;
  return(new);
}

/******************************************************************************/
/** add SQL text to list
 * @return SQL pointer on success
 */

static yadac_sql_t* add_sql(yadac_sql_t *sql, int indent,
 char *text, yadac_param_t *param)
{
  int ctr = 0;
  void *new;


  TRACE("sql: (%u)%s\n", indent, text);

  /* allocate main structure if needed */
  if(!sql && !(sql = calloc(1, sizeof(yadac_sql_t))))
    return(NULL);

  /* allocate space for new SQL line */
  if(!(new = realloc(sql->line, (sizeof(yadac_line_t) * (sql->lines + 2)))))
    {
    free_sql(sql->line);
    free(sql->param);
    free(sql);
    return(NULL);
    }
  sql->line = new;

  /* append SQL line */
  sql->line[sql->lines].indent = indent;
  sql->line[sql->lines++].text = text;
  sql->line[sql->lines].text = NULL;


  /* attach params */
  if(param)
    {
    /* count parameters and fix offsets */
    while(param[ctr])
      {
      param[ctr] -= (INT - YADAC_INT);
      ctr++;
      }

    if(sql->param)
      {
      /* allocate additional space for params */
      if(!(new = realloc(sql->param, (sizeof(int) * (sql->params + ctr)))))
        {
        free_sql(sql->line);
        free(sql->param);
        free(sql);
        return(NULL);
        }
      sql->param = new;
      memcpy((sql->param + sql->params), param, (sizeof(int) * ctr));
      free(param);
      sql->params += ctr;
      }
    else
      {
      sql->param = param;
      sql->params = ctr;
      }
    } /* if(params) */

  return(sql);
}

/******************************************************************************/
/** append binding to parse tree
 * @return 0 on success
 */

static int binding(yadac_t *tree, int ptype, char *name, yadac_sql_t *sql,
 int rtype, yadac_param_t *param, yadac_struct_t *istruct,
 yadac_struct_t *ostruct)
{
  void *new;
  char *upper, *ptr;
  yadac_binding_t *yb;


  TRACE("binding: %s\n", name);

  /* make copy of name for uppercase version */
  if(!(upper = strdup(name)))
    return(-1);
  for(ptr=upper; *ptr; ptr++)
    *ptr = toupper(*ptr);

  /* allocate space for new binding */
  if(!(new = realloc(tree->bind,
   (sizeof(yadac_binding_t) * (tree->binds + 1)))))
    {
    free(upper);
    return(-1);
    }

  tree->bind = new;
  yb = (tree->bind + tree->binds++);

  /* init new binding */
  yb->ptype = ptype;
  yb->rtype = rtype;
  yb->name = name;
  yb->upper = upper;
  yb->line = sql->line;
  yb->lines = sql->lines;
  yb->iparam = sql->param;
  yb->iparams = sql->params;
  yb->oparam = param;
  yb->istruct = istruct;
  yb->ostruct = ostruct;

  /* count output parameters and fix offsets */
  for(yb->oparams=0; (param && param[yb->oparams]); )
    {
    param[yb->oparams] -= (INT - YADAC_INT);
    yb->oparams++;
    }

  /* make sure struct count matches oparam count */
// FIXME - add check for multi
  if(yb->rtype == YADAC_STRUCT && yb->ostruct->list->tokens != yb->oparams)
    printf(
     "WARNING: struct var count does not match output param count for %s\n",
     yb->name);

  free(sql);
  return(0);
}

/******************************************************************************/
/** add include to tree
 * @return 0 on success
 */

static int new_inc(yadac_t *tree, char *str)
{
  void *new;


  /* allocate pointer */
  if(!(new = realloc(tree->inc, (sizeof(char*) * (tree->incs + 1)))))
    return(-1);
  tree->inc = new;
  tree->inc[tree->incs++] = str;

  return(0);
}

/******************************************************************************/


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 315 "yadac.y"
typedef union YYSTYPE {
  char *str;
  int type;
  int num;
  yadac_param_t param;
  yadac_param_t *params;
  yadac_tlist_t *tlist;
  yadac_struct_t *strct;
  yadac_sql_t *sql;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 437 "yadac.y.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 461 "yadac.y.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  8
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   173

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  33
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  13
/* YYNRULES -- Number of rules. */
#define YYNRULES  51
/* YYNRULES -- Number of states. */
#define YYNSTATES  94

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   281

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      31,    32,     2,     2,    30,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,    27,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    28,     2,    29,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     4,     6,     9,    13,    18,    27,    37,
      47,    58,    68,    79,    90,   102,   104,   106,   108,   110,
     112,   114,   116,   118,   120,   122,   124,   126,   128,   130,
     132,   134,   136,   138,   140,   142,   144,   148,   150,   153,
     155,   157,   161,   165,   170,   172,   175,   178,   182,   185,
     189,   193
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      34,     0,    -1,    -1,    35,    -1,    34,    35,    -1,     3,
      24,    27,    -1,    34,     3,    24,    27,    -1,    36,    21,
      28,    45,    29,     6,     7,    27,    -1,    36,    21,    44,
      28,    45,    29,     6,     7,    27,    -1,    36,    21,    28,
      45,    29,     6,     8,    39,    27,    -1,    36,    21,    44,
      28,    45,    29,     6,     8,    39,    27,    -1,    36,    21,
      28,    45,    29,     6,    37,    41,    27,    -1,    36,    21,
      44,    28,    45,    29,     6,    37,    41,    27,    -1,    36,
      21,    28,    45,    29,     6,    38,    44,    41,    27,    -1,
      36,    21,    44,    28,    45,    29,     6,    38,    44,    41,
      27,    -1,     4,    -1,     5,    -1,     9,    -1,    11,    -1,
      10,    -1,    12,    -1,    13,    -1,    17,    -1,    14,    -1,
      18,    -1,    19,    -1,    20,    -1,    13,    -1,    17,    -1,
      14,    -1,    18,    -1,    15,    -1,    19,    -1,    16,    -1,
      20,    -1,    40,    -1,    41,    30,    40,    -1,    40,    -1,
      42,    40,    -1,    25,    -1,    21,    -1,    43,    30,    25,
      -1,    43,    30,    21,    -1,    21,    31,    43,    32,    -1,
      23,    -1,    42,    23,    -1,    26,    23,    -1,    26,    42,
      23,    -1,    45,    23,    -1,    45,    42,    23,    -1,    45,
      26,    23,    -1,    45,    26,    42,    23,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   353,   353,   354,   355,   356,   357,   360,   363,   366,
     370,   374,   377,   380,   385,   393,   394,   398,   399,   403,
     404,   408,   409,   410,   411,   412,   413,   417,   418,   419,
     420,   421,   422,   423,   424,   428,   429,   433,   434,   438,
     439,   440,   441,   443,   446,   447,   448,   449,   450,   451,
     452,   453
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "INCLUDE", "PREPARE", "YPREPARE", "RESULT", 
  "STATUS", "SIMPLE", "SINGLE", "STRUCT", "MULTIROW", "MULTISTRUCT", 
  "INT", "LONG", "BINARY", "VARCHAR", "INTP", "LONGP", "BINARYP", 
  "VARCHARP", "TOKEN", "PARAM", "SQL", "STRING", "CVAR", "INDENT", "';'", 
  "'['", "']'", "','", "'('", "')'", "$accept", "all", "binding", "ptype", 
  "rtype", "rstype", "simple", "param", "oparams", "iparams", "tlist", 
  "strct", "sql", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,    59,    91,    93,
      44,    40,    41
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    33,    34,    34,    34,    34,    34,    35,    35,    35,
      35,    35,    35,    35,    35,    36,    36,    37,    37,    38,
      38,    39,    39,    39,    39,    39,    39,    40,    40,    40,
      40,    40,    40,    40,    40,    41,    41,    42,    42,    43,
      43,    43,    43,    44,    45,    45,    45,    45,    45,    45,
      45,    45
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     0,     1,     2,     3,     4,     8,     9,     9,
      10,     9,    10,    10,    11,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     1,     2,     1,
       1,     3,     3,     4,     1,     2,     2,     3,     2,     3,
       3,     4
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       2,     0,    15,    16,     0,     3,     0,     0,     1,     0,
       4,     0,     5,     0,     0,     0,     0,     6,     0,    27,
      29,    31,    33,    28,    30,    32,    34,    44,     0,    37,
       0,     0,     0,    40,    39,     0,    46,     0,    45,    38,
      48,     0,     0,     0,     0,     0,    43,    47,    50,     0,
       0,    49,     0,    42,    41,    51,     0,     0,    17,    19,
      18,    20,     0,     0,     0,     7,    21,    23,    22,    24,
      25,    26,     0,    35,     0,     0,     0,     0,     0,     0,
       9,    11,     0,     0,     8,     0,     0,     0,    36,    13,
      10,    12,     0,    14
};

/* YYDEFGOTO[NTERM-NUM]. */
static const yysigned_char yydefgoto[] =
{
      -1,     4,     5,     6,    62,    63,    72,    29,    74,    30,
      35,    16,    31
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -73
static const short yypact[] =
{
     164,   -15,   -73,   -73,    51,   -73,   -11,     1,   -73,    -8,
     -73,   -16,   -73,     2,     3,    45,    52,   -73,    10,   -73,
     -73,   -73,   -73,   -73,   -73,   -73,   -73,   -73,    59,   -73,
      70,     7,    45,   -73,   -73,   141,   -73,    81,   -73,   -73,
     -73,    92,    75,   103,    24,   145,   -73,   -73,   -73,   114,
     147,   -73,    85,   -73,   -73,   -73,    65,   133,   -73,   -73,
     -73,   -73,   125,    82,   153,   -73,   -73,   -73,   -73,   -73,
     -73,   -73,    86,   -73,   -19,   125,    87,   133,   125,    82,
     -73,   -73,   125,    19,   -73,    97,    39,   125,   -73,   -73,
     -73,   -73,    40,   -73
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -73,   -73,    98,   -73,    61,    71,    72,   -30,   -72,   -27,
     -73,   -61,   104
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -1
static const unsigned char yytable[] =
{
      39,    37,    75,    83,    43,    14,    86,    39,    81,     7,
      11,    82,    15,    39,    49,    92,    13,    43,    87,    39,
      19,    20,    21,    22,    23,    24,    25,    26,    12,    17,
      40,    33,    73,    41,    18,    34,    42,    19,    20,    21,
      22,    23,    24,    25,    26,    73,    89,    40,    73,    82,
      41,     8,    88,    52,     9,     2,     3,    73,    19,    20,
      21,    22,    23,    24,    25,    26,    91,    93,    27,    82,
      82,    28,    19,    20,    21,    22,    23,    24,    25,    26,
      32,    50,    36,    19,    20,    21,    22,    23,    24,    25,
      26,    64,    65,    38,    19,    20,    21,    22,    23,    24,
      25,    26,    10,    14,    47,    19,    20,    21,    22,    23,
      24,    25,    26,    80,    84,    48,    19,    20,    21,    22,
      23,    24,    25,    26,    90,    78,    51,    19,    20,    21,
      22,    23,    24,    25,    26,    79,    44,    55,    19,    20,
      21,    22,    23,    24,    25,    26,    66,    67,     0,    85,
      68,    69,    70,    71,    56,    57,    58,    59,    60,    61,
      76,    77,    58,    59,    60,    61,    53,     1,     2,     3,
      54,    45,     0,    46
};

static const yysigned_char yycheck[] =
{
      30,    28,    63,    75,    31,    21,    78,    37,    27,    24,
      21,    30,    28,    43,    41,    87,    24,    44,    79,    49,
      13,    14,    15,    16,    17,    18,    19,    20,    27,    27,
      23,    21,    62,    26,    31,    25,    29,    13,    14,    15,
      16,    17,    18,    19,    20,    75,    27,    23,    78,    30,
      26,     0,    82,    29,     3,     4,     5,    87,    13,    14,
      15,    16,    17,    18,    19,    20,    27,    27,    23,    30,
      30,    26,    13,    14,    15,    16,    17,    18,    19,    20,
      28,     6,    23,    13,    14,    15,    16,    17,    18,    19,
      20,     6,    27,    23,    13,    14,    15,    16,    17,    18,
      19,    20,     4,    21,    23,    13,    14,    15,    16,    17,
      18,    19,    20,    27,    27,    23,    13,    14,    15,    16,
      17,    18,    19,    20,    27,    64,    23,    13,    14,    15,
      16,    17,    18,    19,    20,    64,    32,    23,    13,    14,
      15,    16,    17,    18,    19,    20,    13,    14,    -1,    77,
      17,    18,    19,    20,     7,     8,     9,    10,    11,    12,
       7,     8,     9,    10,    11,    12,    21,     3,     4,     5,
      25,    30,    -1,    32
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     3,     4,     5,    34,    35,    36,    24,     0,     3,
      35,    21,    27,    24,    21,    28,    44,    27,    31,    13,
      14,    15,    16,    17,    18,    19,    20,    23,    26,    40,
      42,    45,    28,    21,    25,    43,    23,    42,    23,    40,
      23,    26,    29,    42,    45,    30,    32,    23,    23,    42,
       6,    23,    29,    21,    25,    23,     7,     8,     9,    10,
      11,    12,    37,    38,     6,    27,    13,    14,    17,    18,
      19,    20,    39,    40,    41,    44,     7,     8,    37,    38,
      27,    27,    30,    41,    27,    39,    41,    44,    40,    27,
      27,    27,    41,    27
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror (&yylloc, scanner, tree, "syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (&yylval, &yylloc, YYLEX_PARAM)
#else
# define YYLEX yylex (&yylval, &yylloc, scanner)
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value, Location);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep, yylocationp)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;
  (void) yylocationp;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep, YYLTYPE *yylocationp)
#else
static void
yydestruct (yytype, yyvaluep, yylocationp)
    int yytype;
    YYSTYPE *yyvaluep;
    YYLTYPE *yylocationp;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;
  (void) yylocationp;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (yyscan_t scanner, yadac_t *tree);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */






/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (yyscan_t scanner, yadac_t *tree)
#else
int
yyparse (scanner, tree)
    yyscan_t scanner;
    yadac_t *tree;
#endif
#endif
{
  /* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;
/* Location data for the lookahead symbol.  */
YYLTYPE yylloc;

  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;

  /* The location stack.  */
  YYLTYPE yylsa[YYINITDEPTH];
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;
  YYLTYPE *yylerrsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;
  yylsp = yyls;
  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;
	YYLTYPE *yyls1 = yyls;

	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),
		    &yyls1, yysize * sizeof (*yylsp),
		    &yystacksize);
	yyls = yyls1;
	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);
	YYSTACK_RELOCATE (yyls);
#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
  *++yylsp = yylloc;

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 5:
#line 356 "yadac.y"
    { new_inc(tree, yyvsp[-1].str); }
    break;

  case 6:
#line 357 "yadac.y"
    { new_inc(tree, yyvsp[-1].str); }
    break;

  case 7:
#line 361 "yadac.y"
    { binding(tree, yyvsp[-7].type, yyvsp[-6].str, yyvsp[-4].sql,
					 YADAC_STATUS, NULL, NULL, NULL); }
    break;

  case 8:
#line 364 "yadac.y"
    { binding(tree, yyvsp[-8].type, yyvsp[-7].str, yyvsp[-4].sql,
					 YADAC_STATUS, NULL, yyvsp[-6].strct, NULL); }
    break;

  case 9:
#line 367 "yadac.y"
    { binding(tree, yyvsp[-8].type, yyvsp[-7].str, yyvsp[-5].sql,
					 YADAC_SIMPLE, add_param(NULL, yyvsp[-1].param),
					 NULL, NULL); }
    break;

  case 10:
#line 371 "yadac.y"
    { binding(tree, yyvsp[-9].type, yyvsp[-8].str, yyvsp[-5].sql,
					 YADAC_SIMPLE, add_param(NULL, yyvsp[-1].param),
					 yyvsp[-7].strct, NULL); }
    break;

  case 11:
#line 375 "yadac.y"
    { binding(tree, yyvsp[-8].type, yyvsp[-7].str, yyvsp[-5].sql, yyvsp[-2].type, yyvsp[-1].params,
					 NULL, NULL); }
    break;

  case 12:
#line 378 "yadac.y"
    { binding(tree, yyvsp[-9].type, yyvsp[-8].str, yyvsp[-5].sql, yyvsp[-2].type, yyvsp[-1].params,
					 yyvsp[-7].strct, NULL); }
    break;

  case 13:
#line 383 "yadac.y"
    { binding(tree, yyvsp[-9].type, yyvsp[-8].str, yyvsp[-6].sql, yyvsp[-3].type, yyvsp[-1].params,
					 NULL, yyvsp[-2].strct); }
    break;

  case 14:
#line 388 "yadac.y"
    { binding(tree, yyvsp[-10].type, yyvsp[-9].str, yyvsp[-6].sql, yyvsp[-3].type, yyvsp[-1].params,
					 yyvsp[-8].strct, yyvsp[-2].strct); }
    break;

  case 15:
#line 393 "yadac.y"
    { yyval.type = YADAC_PREPARE; }
    break;

  case 16:
#line 394 "yadac.y"
    { yyval.type = YADAC_YPREPARE; }
    break;

  case 17:
#line 398 "yadac.y"
    { yyval.type = YADAC_SINGLE; }
    break;

  case 18:
#line 399 "yadac.y"
    { yyval.type = YADAC_MULTIROW; }
    break;

  case 19:
#line 403 "yadac.y"
    { yyval.type = YADAC_STRUCT; }
    break;

  case 20:
#line 404 "yadac.y"
    { yyval.type = YADAC_MULTISTRUCT; }
    break;

  case 35:
#line 428 "yadac.y"
    { yyval.params = add_param(NULL, yyvsp[0].param); }
    break;

  case 36:
#line 429 "yadac.y"
    { yyval.params = add_param(yyvsp[-2].params, yyvsp[0].param); }
    break;

  case 37:
#line 433 "yadac.y"
    { yyval.params = add_param(NULL, yyvsp[0].param); }
    break;

  case 38:
#line 434 "yadac.y"
    { yyval.params = add_param(yyvsp[-1].params, yyvsp[0].param); }
    break;

  case 39:
#line 438 "yadac.y"
    { yyval.tlist = add_token(NULL, yyvsp[0].str); }
    break;

  case 40:
#line 439 "yadac.y"
    { yyval.tlist = add_token(NULL, yyvsp[0].str); }
    break;

  case 41:
#line 440 "yadac.y"
    { yyval.tlist = add_token(yyvsp[-2].tlist, yyvsp[0].str); }
    break;

  case 42:
#line 441 "yadac.y"
    { yyval.tlist = add_token(yyvsp[-2].tlist, yyvsp[0].str); }
    break;

  case 43:
#line 443 "yadac.y"
    { yyval.strct = add_struct(yyvsp[-3].str, yyvsp[-1].tlist); }
    break;

  case 44:
#line 446 "yadac.y"
    { yyval.sql = add_sql(NULL, 0, yyvsp[0].str, NULL); }
    break;

  case 45:
#line 447 "yadac.y"
    { yyval.sql = add_sql(NULL, 0, yyvsp[0].str, yyvsp[-1].params); }
    break;

  case 46:
#line 448 "yadac.y"
    { yyval.sql = add_sql(NULL, yyvsp[-1].num, yyvsp[0].str, NULL); }
    break;

  case 47:
#line 449 "yadac.y"
    { yyval.sql = add_sql(NULL, yyvsp[-2].num, yyvsp[0].str, yyvsp[-1].params); }
    break;

  case 48:
#line 450 "yadac.y"
    { yyval.sql = add_sql(yyvsp[-1].sql, 0, yyvsp[0].str, NULL); }
    break;

  case 49:
#line 451 "yadac.y"
    { yyval.sql = add_sql(yyvsp[-2].sql, 0, yyvsp[0].str, yyvsp[-1].params); }
    break;

  case 50:
#line 452 "yadac.y"
    { yyval.sql = add_sql(yyvsp[-2].sql, yyvsp[-1].num, yyvsp[0].str, NULL); }
    break;

  case 51:
#line 453 "yadac.y"
    { yyval.sql = add_sql(yyvsp[-3].sql, yyvsp[-2].num, yyvsp[0].str, yyvsp[-1].params); }
    break;


    }

/* Line 991 of yacc.c.  */
#line 1622 "yadac.y.c"

  yyvsp -= yylen;
  yyssp -= yylen;
  yylsp -= yylen;

  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (&yylloc, scanner, tree, yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror (&yylloc, scanner, tree, "syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror (&yylloc, scanner, tree, "syntax error");
    }

  yylerrsp = yylsp;

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp, yylsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval, &yylloc);
      yychar = YYEMPTY;
      *++yylerrsp = yylloc;
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab2;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:

  /* Suppress GCC warning that yyerrlab1 is unused when no action
     invokes YYERROR.  */
#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__)
  __attribute__ ((__unused__))
#endif

  yylerrsp = yylsp;
  *++yylerrsp = yyloc;
  goto yyerrlab2;


/*---------------------------------------------------------------.
| yyerrlab2 -- pop states until the error token can be shifted.  |
`---------------------------------------------------------------*/
yyerrlab2:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp, yylsp);
      yyvsp--;
      yystate = *--yyssp;
      yylsp--;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;
  YYLLOC_DEFAULT (yyloc, yylsp, (yylerrsp - yylsp));
  *++yylsp = yyloc;

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror (&yylloc, scanner, tree, "parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 457 "yadac.y"

/******************************************************************************
 * F U N C T I O N S **********************************************************
 ******************************************************************************/

/******************************************************************************/
/** convert buffer to parse tree
 * @return yada bindings pointer on success
 */

yadac_t* yadac_parse(char *buf, int siz)
{
  yadac_t *tree;
  yyscan_t scanner;


  /* allocate structure */
  if(!(tree = calloc(1, sizeof(yadac_t))))
    return(NULL);

  /* initialize the scanner */
  yylex_init(&scanner);
  yy_scan_bytes(buf, siz, scanner);

  if(yyparse(scanner, tree))
    {
    yylex_destroy(scanner);
    yadac_free(tree);
    return(NULL);
    }

  yylex_destroy(scanner);
  return(tree);
}

/******************************************************************************/
/** free yada bindings
 */

void yadac_free(yadac_t *tree)
{
  int loop;


  if(!tree)
    return;

  /* free each binding */
  for(loop=0; loop<tree->binds; loop++)
    {
    free_sql(tree->bind[loop].line);
    free(tree->bind[loop].iparam);
    free(tree->bind[loop].oparam);
    free(tree->bind[loop].name);
    }

  free(tree->bind);
  free(tree);
}

/******************************************************************************
 ******************************************************************************/


