/* Generated by GOB (v2.0.14)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 14

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-evolution-glue.h"

#include "mn-evolution-glue-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 31 "mn-evolution-glue.gob"

#include <stdio.h>
#include <camel/camel-folder.h>
#include <mail/em-folder-view.h>
#include <mail/em-format.h>
#include <mail/em-message-browser.h>
#include <mail/em-utils.h>
#include <mail/mail-session.h>
#include <mail/mail-tools.h>

GSList *mn_evolution_glues = NULL;

/* see https://bugzilla.redhat.com/bugzilla/show_bug.cgi?id=208774 */
static GHashTable *folders = NULL;

typedef struct
{
  char		*uri;
  CamelFolder	*folder;
} FolderInfo;

#line 48 "mn-evolution-glue.c"
/* self casting macros */
#define SELF(x) MN_EVOLUTION_GLUE(x)
#define SELF_CONST(x) MN_EVOLUTION_GLUE_CONST(x)
#define IS_SELF(x) MN_IS_EVOLUTION_GLUE(x)
#define TYPE_SELF MN_TYPE_EVOLUTION_GLUE
#define SELF_CLASS(x) MN_EVOLUTION_GLUE_CLASS(x)

#define SELF_GET_CLASS(x) MN_EVOLUTION_GLUE_GET_CLASS(x)

/* self typedefs */
typedef MNEvolutionGlue Self;
typedef MNEvolutionGlueClass SelfClass;

/* here are local prototypes */
static void mn_evolution_glue_init (MNEvolutionGlue * o) G_GNUC_UNUSED;
static void mn_evolution_glue_class_init (MNEvolutionGlueClass * c) G_GNUC_UNUSED;
static GObject * ___1_mn_evolution_glue_constructor (GType type, unsigned int n_construct_properties, GObjectConstructParam * construct_params) G_GNUC_UNUSED;
static void ___2_mn_evolution_glue_finalize (GObject * object) G_GNUC_UNUSED;
static CORBA_char * mn_evolution_glue_CORBA_string_dup_null (const CORBA_char * str) G_GNUC_UNUSED;
static void mn_evolution_glue_cache_folder (const char * uri, CamelFolder * folder) G_GNUC_UNUSED;
static void mn_evolution_glue_folder_info_free (FolderInfo * info) G_GNUC_UNUSED;
static void mn_evolution_glue_folder_deleted_cb (CamelObject * object, gpointer event_data, gpointer user_data) G_GNUC_UNUSED;
static CamelFolder * mn_evolution_glue_lookup_folder (const char * uri, CORBA_Environment * env) G_GNUC_UNUSED;
static GNOME_MailNotification_Evolution_MessageSeq * mn_evolution_glue_getUnseenMessages (PortableServer_Servant servant, const CORBA_char * folder_uri, CORBA_Environment * env) G_GNUC_UNUSED;
static CORBA_string mn_evolution_glue_getFolderName (PortableServer_Servant servant, const CORBA_char * folder_uri, CORBA_Environment * env) G_GNUC_UNUSED;
static void mn_evolution_glue_openMessage (PortableServer_Servant servant, const CORBA_char * folder_uri, const CORBA_char * message_uid, CORBA_Environment * env) G_GNUC_UNUSED;
static void mn_evolution_glue_setMessageFlags (PortableServer_Servant servant, const CORBA_char * folder_uri, const CORBA_char * message_uid, CORBA_unsigned_long flags, CORBA_Environment * env) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static BonoboObjectClass *parent_class = NULL;

/* Short form macros */
#define self_CORBA_string_dup_null mn_evolution_glue_CORBA_string_dup_null
#define self_cache_folder mn_evolution_glue_cache_folder
#define self_folder_info_free mn_evolution_glue_folder_info_free
#define self_folder_deleted_cb mn_evolution_glue_folder_deleted_cb
#define self_lookup_folder mn_evolution_glue_lookup_folder
#define self_getUnseenMessages mn_evolution_glue_getUnseenMessages
#define self_getFolderName mn_evolution_glue_getFolderName
#define self_openMessage mn_evolution_glue_openMessage
#define self_setMessageFlags mn_evolution_glue_setMessageFlags
#define self_factory_cb mn_evolution_glue_factory_cb
#define self_global_cleanup mn_evolution_glue_global_cleanup
GType
mn_evolution_glue_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNEvolutionGlueClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_evolution_glue_class_init,
			NULL, /* class_finalize */
			NULL, /* class_data */
			sizeof (MNEvolutionGlue),
			0, /* n_preallocs */
			(GInstanceInitFunc)  mn_evolution_glue_init,
			NULL
		};

		type = bonobo_type_unique (
			BONOBO_OBJECT_TYPE,
			POA_GNOME_MailNotification_Evolution_Glue__init, NULL,
			G_STRUCT_OFFSET (MNEvolutionGlueClass, _epv),
			&info, "MNEvolutionGlue");
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNEvolutionGlue *)g_object_new(mn_evolution_glue_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNEvolutionGlue * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNEvolutionGlue *
GET_NEW_VARG (const char *first, ...)
{
	MNEvolutionGlue *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNEvolutionGlue *)g_object_new_valist (mn_evolution_glue_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
mn_evolution_glue_init (MNEvolutionGlue * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Evolution:Glue::init"
}
#undef __GOB_FUNCTION__
static void 
mn_evolution_glue_class_init (MNEvolutionGlueClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Evolution:Glue::class_init"
	GObjectClass *g_object_class = (GObjectClass *)c;

	parent_class = g_type_class_ref (BONOBO_TYPE_OBJECT);

#line 57 "mn-evolution-glue.gob"
	g_object_class->constructor = ___1_mn_evolution_glue_constructor;
#line 78 "mn-evolution-glue.gob"
	g_object_class->finalize = ___2_mn_evolution_glue_finalize;
#line 156 "mn-evolution-glue.c"
#line 165 "mn-evolution-glue.gob"
	c->_epv.getUnseenMessages = self_getUnseenMessages;
#line 233 "mn-evolution-glue.gob"
	c->_epv.getFolderName = self_getFolderName;
#line 251 "mn-evolution-glue.gob"
	c->_epv.openMessage = self_openMessage;
#line 276 "mn-evolution-glue.gob"
	c->_epv.setMessageFlags = self_setMessageFlags;
#line 165 "mn-evolution-glue.c"
}
#undef __GOB_FUNCTION__



#line 57 "mn-evolution-glue.gob"
static GObject * 
___1_mn_evolution_glue_constructor (GType type G_GNUC_UNUSED, unsigned int n_construct_properties, GObjectConstructParam * construct_params)
#line 174 "mn-evolution-glue.c"
#define PARENT_HANDLER(___type,___n_construct_properties,___construct_params) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_construct_properties,___construct_params): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "MN:Evolution:Glue::constructor"
{
#line 59 "mn-evolution-glue.gob"
	
    GObject *object;
    Self *self;

    object = PARENT_HANDLER(type, n_construct_properties, construct_params);
    self = SELF(object);

    self->es = bonobo_event_source_new();
    /*
     * bonobo_object_add_interface() takes ownership of the passed
     * object, that's why we must not unref es above.
     */
    bonobo_object_add_interface(BONOBO_OBJECT(self), BONOBO_OBJECT(self->es));

    mn_evolution_glues = g_slist_append(mn_evolution_glues, self);

    return object;
  }}
#line 201 "mn-evolution-glue.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 78 "mn-evolution-glue.gob"
static void 
___2_mn_evolution_glue_finalize (GObject * object G_GNUC_UNUSED)
#line 208 "mn-evolution-glue.c"
#define PARENT_HANDLER(___object) \
	{ if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(___object); }
{
#define __GOB_FUNCTION__ "MN:Evolution:Glue::finalize"
{
#line 80 "mn-evolution-glue.gob"
	
    mn_evolution_glues = g_slist_remove(mn_evolution_glues, object);

    PARENT_HANDLER(object);
  }}
#line 221 "mn-evolution-glue.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 90 "mn-evolution-glue.gob"
static CORBA_char * 
mn_evolution_glue_CORBA_string_dup_null (const CORBA_char * str)
#line 228 "mn-evolution-glue.c"
{
#define __GOB_FUNCTION__ "MN:Evolution:Glue::CORBA_string_dup_null"
{
#line 92 "mn-evolution-glue.gob"
	
    return CORBA_string_dup(str ? str : "");
  }}
#line 236 "mn-evolution-glue.c"
#undef __GOB_FUNCTION__

#line 96 "mn-evolution-glue.gob"
static void 
mn_evolution_glue_cache_folder (const char * uri, CamelFolder * folder)
#line 242 "mn-evolution-glue.c"
{
#define __GOB_FUNCTION__ "MN:Evolution:Glue::cache_folder"
#line 96 "mn-evolution-glue.gob"
	g_return_if_fail (uri != NULL);
#line 96 "mn-evolution-glue.gob"
	g_return_if_fail (folder != NULL);
#line 249 "mn-evolution-glue.c"
{
#line 99 "mn-evolution-glue.gob"
	
    FolderInfo *info;

    info = g_new0(FolderInfo, 1);
    info->uri = g_strdup(uri);
    info->folder = folder;
    camel_object_ref(folder);

    /* uncache the folder when it is deleted */
    camel_object_hook_event(folder, "deleted", self_folder_deleted_cb, info);

    g_hash_table_replace(folders, info->uri, info);
  }}
#line 265 "mn-evolution-glue.c"
#undef __GOB_FUNCTION__

#line 113 "mn-evolution-glue.gob"
static void 
mn_evolution_glue_folder_info_free (FolderInfo * info)
#line 271 "mn-evolution-glue.c"
{
#define __GOB_FUNCTION__ "MN:Evolution:Glue::folder_info_free"
#line 113 "mn-evolution-glue.gob"
	g_return_if_fail (info != NULL);
#line 276 "mn-evolution-glue.c"
{
#line 115 "mn-evolution-glue.gob"
	
    camel_object_unhook_event(info->folder, "deleted", self_folder_deleted_cb, info);
    camel_object_unref(info->folder);
    g_free(info->uri);
    g_free(info);
  }}
#line 285 "mn-evolution-glue.c"
#undef __GOB_FUNCTION__

#line 122 "mn-evolution-glue.gob"
static void 
mn_evolution_glue_folder_deleted_cb (CamelObject * object, gpointer event_data, gpointer user_data)
#line 291 "mn-evolution-glue.c"
{
#define __GOB_FUNCTION__ "MN:Evolution:Glue::folder_deleted_cb"
{
#line 126 "mn-evolution-glue.gob"
	
    FolderInfo *info = user_data;
    gboolean status;

    status = g_hash_table_remove(folders, info->uri);
    g_assert(status == TRUE);
  }}
#line 303 "mn-evolution-glue.c"
#undef __GOB_FUNCTION__

#line 134 "mn-evolution-glue.gob"
static CamelFolder * 
mn_evolution_glue_lookup_folder (const char * uri, CORBA_Environment * env)
#line 309 "mn-evolution-glue.c"
{
#define __GOB_FUNCTION__ "MN:Evolution:Glue::lookup_folder"
#line 134 "mn-evolution-glue.gob"
	g_return_val_if_fail (uri != NULL, (CamelFolder * )0);
#line 314 "mn-evolution-glue.c"
{
#line 136 "mn-evolution-glue.gob"
	
    CamelFolder *folder = NULL;

    if (folders)
      {
	FolderInfo *info;

	info = g_hash_table_lookup(folders, uri);
	if (info)
	  {
	    folder = info->folder;
	    camel_object_ref(folder);
	  }
      }
    else
      folders = g_hash_table_new_full(g_str_hash, g_str_equal, NULL, (GDestroyNotify) self_folder_info_free);

    if (! folder)
      {
	folder = mail_tool_uri_to_folder(uri, 0, NULL);
	if (folder)
	  self_cache_folder(uri, folder);
	else
	  bonobo_exception_set(env, ex_GNOME_MailNotification_Evolution_Glue_FolderNotFound);
      }

    return folder;
  }}
#line 345 "mn-evolution-glue.c"
#undef __GOB_FUNCTION__

#line 165 "mn-evolution-glue.gob"
static GNOME_MailNotification_Evolution_MessageSeq * 
mn_evolution_glue_getUnseenMessages (PortableServer_Servant servant, const CORBA_char * folder_uri, CORBA_Environment * env)
#line 351 "mn-evolution-glue.c"
{
#define __GOB_FUNCTION__ "MN:Evolution:Glue::getUnseenMessages"
{
#line 169 "mn-evolution-glue.gob"
	
    CamelFolder *folder;
    GPtrArray *summary;
    int i;
    GSList *infos = NULL;
    GNOME_MailNotification_Evolution_MessageSeq *seq;

    folder = self_lookup_folder(folder_uri, env);
    if (! folder)
      return NULL;

    summary = camel_folder_get_summary(folder);

    seq = GNOME_MailNotification_Evolution_MessageSeq__alloc();
    seq->_length = 0;

    for (i = 0; i < summary->len; i++)
      {
	CamelMessageInfo *info = summary->pdata[i];

	if ((camel_message_info_flags(info) & CAMEL_MESSAGE_SEEN) == 0)
	  {
	    infos = g_slist_prepend(infos, info);
	    seq->_length++;
	  }
      }

    if (seq->_length > 0)
      {
	GSList *l;

	seq->_buffer = CORBA_sequence_GNOME_MailNotification_Evolution_Message_allocbuf(seq->_length);
	for (l = infos, i = 0; l != NULL; l = l->next, i++)
	  {
	    CamelMessageInfo *info = l->data;
	    const CamelSummaryMessageID *id;
	    char hexhash[sizeof(CamelSummaryMessageID) * 2 + 1];
	    int j;

	    id = camel_message_info_message_id(info);
	    for (j = 0; j < sizeof(id->id.hash); j++)
	      sprintf(hexhash + j * 2, "%.2x", id->id.hash[j]);

	    g_assert(camel_message_info_uid(info) != NULL);

	    seq->_buffer[i].uid = CORBA_string_dup(camel_message_info_uid(info));
	    seq->_buffer[i].sent_time = camel_message_info_date_sent(info);
	    seq->_buffer[i].received_time = camel_message_info_date_received(info);
	    seq->_buffer[i].id = CORBA_string_dup(hexhash);
	    seq->_buffer[i].from = self_CORBA_string_dup_null(camel_message_info_from(info));
	    seq->_buffer[i].subject = self_CORBA_string_dup_null(camel_message_info_subject(info));
	  }

	CORBA_sequence_set_release(seq, CORBA_TRUE);

	g_slist_free(infos);
      }

    camel_folder_free_summary(folder, summary);
    camel_object_unref(folder);

    return seq;
  }}
#line 419 "mn-evolution-glue.c"
#undef __GOB_FUNCTION__

#line 233 "mn-evolution-glue.gob"
static CORBA_string 
mn_evolution_glue_getFolderName (PortableServer_Servant servant, const CORBA_char * folder_uri, CORBA_Environment * env)
#line 425 "mn-evolution-glue.c"
{
#define __GOB_FUNCTION__ "MN:Evolution:Glue::getFolderName"
{
#line 237 "mn-evolution-glue.gob"
	
    CamelFolder *folder;
    CORBA_string name = NULL;

    folder = self_lookup_folder(folder_uri, env);
    if (folder)
      {
	name = self_CORBA_string_dup_null(camel_folder_get_name(folder));
	camel_object_unref(folder);
      }

    return name;
  }}
#line 443 "mn-evolution-glue.c"
#undef __GOB_FUNCTION__

#line 251 "mn-evolution-glue.gob"
static void 
mn_evolution_glue_openMessage (PortableServer_Servant servant, const CORBA_char * folder_uri, const CORBA_char * message_uid, CORBA_Environment * env)
#line 449 "mn-evolution-glue.c"
{
#define __GOB_FUNCTION__ "MN:Evolution:Glue::openMessage"
{
#line 256 "mn-evolution-glue.gob"
	
    CamelFolder *folder;
    GtkWidget *browser;

    folder = self_lookup_folder(folder_uri, env);
    if (! folder)
      return;

    /* modelled after Evolution's handleuri_got_folder() */

    browser = em_message_browser_window_new();

    em_format_set_session((EMFormat *) ((EMFolderView *) browser)->preview, session);
    em_folder_view_set_folder((EMFolderView *) browser, folder, folder_uri);
    em_folder_view_set_message((EMFolderView *) browser, message_uid, FALSE);
    gtk_widget_show(((EMMessageBrowser *) browser)->window);

    camel_object_unref(folder);
  }}
#line 473 "mn-evolution-glue.c"
#undef __GOB_FUNCTION__

#line 276 "mn-evolution-glue.gob"
static void 
mn_evolution_glue_setMessageFlags (PortableServer_Servant servant, const CORBA_char * folder_uri, const CORBA_char * message_uid, CORBA_unsigned_long flags, CORBA_Environment * env)
#line 479 "mn-evolution-glue.c"
{
#define __GOB_FUNCTION__ "MN:Evolution:Glue::setMessageFlags"
{
#line 282 "mn-evolution-glue.gob"
	
    CamelFolder *folder;

    folder = self_lookup_folder(folder_uri, env);
    if (! folder)
      return;

    if (! camel_folder_set_message_flags(folder, message_uid, flags, flags))
      bonobo_exception_set(env, ex_GNOME_MailNotification_Evolution_Glue_MessageNotFound);

    camel_object_unref(folder);
  }}
#line 496 "mn-evolution-glue.c"
#undef __GOB_FUNCTION__

#line 295 "mn-evolution-glue.gob"
BonoboObject * 
mn_evolution_glue_factory_cb (BonoboGenericFactory * factory, const char * iid, gpointer closure)
#line 502 "mn-evolution-glue.c"
{
#define __GOB_FUNCTION__ "MN:Evolution:Glue::factory_cb"
{
#line 299 "mn-evolution-glue.gob"
	
    return BONOBO_OBJECT(GET_NEW);
  }}
#line 510 "mn-evolution-glue.c"
#undef __GOB_FUNCTION__

#line 303 "mn-evolution-glue.gob"
void 
mn_evolution_glue_global_cleanup (void)
#line 516 "mn-evolution-glue.c"
{
#define __GOB_FUNCTION__ "MN:Evolution:Glue::global_cleanup"
{
#line 305 "mn-evolution-glue.gob"
	
    g_slist_foreach(mn_evolution_glues, (GFunc) bonobo_object_unref, NULL);
    g_slist_free(mn_evolution_glues);
    mn_evolution_glues = NULL;

    g_hash_table_destroy(folders);
    folders = NULL;
  }}
#line 529 "mn-evolution-glue.c"
#undef __GOB_FUNCTION__
