/*
    kqcstringsplitter.h

    KMime, the KDE internet mail/usenet news message library.
    Copyright (c) 2001 the KMime authors.
    See file AUTHORS for details

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef KQCSTRINGSPLITTER_H
#define KQCSTRINGSPLITTER_H

#include <qcstring.h>

class KQCStringSplitter {
  
  public:
    KQCStringSplitter();
    ~KQCStringSplitter();
        
    void reset()                  { start=0; end=0; sep=""; incSep=false;}
    
    void init(const QCString &str, const char *s);
    void init(const char *str, const char *s);
    void setIncludeSep(bool inc)  { incSep=inc; }
    
    bool first();
    bool last();
    
    bool next();
    bool prev();  
      
    QCString& string()              { return dst; }
    const QCString& source()        { return src; }
          
  private:
    QCString src, dst, sep;
    int start,end;
    bool incSep;
      
};

#endif
