// pwrmate.h
// 
// Written and pasted together code snippets by Mike Studer AB6CV
// 2004-11-9
//
#ifndef PWRMATE_H
#define PWRMATE_H

// OS includes
#include <linux/input.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>

// Qt includes
#include <qmessagebox.h>
#include <qobject.h>
#include <qthread.h>

// Local includes
#include "findpowermate.h"


#ifndef MSC_PULSELED
/* this may not have made its way into the kernel headers yet ... */
#define MSC_PULSELED 0x01
#endif

class pwrmate: public QObject, public QThread
{
    Q_OBJECT
public:
    virtual void run();

    void powermate_pulse_led(int);
    void powermate_pulse_led_off(void);
    void process_event(struct input_event*);
private:
    int fdp;
    int fdr;
    int static_brightness;
    int pulse_speed;
    int pulse_table;
    int pulse_asleep;
    int pulse_awake;

signals:
    void dialed(int);
    void btnpress(int);
};


#endif
