#! /usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright 2003, Matthias A. Benkard.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


import core.common
from core.common import _

import logging

log = logging.getLogger("main")

def main():
	core.common.init()
	log.info(_("Starting Mascyma."))
	
	if core.common.toolkit == 'wx':
		import wxgui.main
		wxgui.main.main()
	elif core.common.toolkit == 'gtk':
		import gui.main
		gui.main.main()

if __name__ == '__main__':
	main()

