from __future__ import division
from cbook import iterable

class ColormapJet:
   def __init__(self, N):
      self.N = N      
      self.indmax = self.N-1

      self._jet_make_red()
      self._jet_make_blue()
      self._jet_make_green()

      self.rgbs =  zip(self.red, self.green, self.blue)
      
   def _jet_make_red(self):

      fracon = 0.35
      fracmax = 0.66
      fracdown = 0.89
      mup = 1/(fracmax - fracon)
      mdown = -0.5/(1-fracdown)
      self.red = []
      for i in range(self.N):
         frac = i/self.N
         if frac < fracon: thisval = 0
         elif frac >=fracon and frac<=fracmax: thisval = mup * (frac-fracon)
         elif frac > fracmax and frac<fracdown: thisval = 1.0
         else: thisval = 1+mdown*(frac-fracdown)
         self.red.append( thisval )

   def _jet_make_blue(self):
       #blue is just red flipped left/right
       if not self.__dict__.has_key('red'):
          s = 'You must call _jet_make_red before _jet_make_blue'
          raise RuntimeError, s
                 
       self.blue = [self.red[i] for i in range(self.indmax,-1,-1)]


   def _jet_make_green(self):

      fracon = 0.1250
      fracmax = 0.375
      fracdown = 0.64
      fracoff = 0.91
      mup = 1/(fracmax - fracon)
      mdown = -1/(fracoff-fracdown)
      self.green = []
      for i in range(self.N):
         frac = i/self.N
         if frac < fracon: thisval = 0
         elif frac >=fracon and frac<=fracmax: thisval = mup * (frac-fracon)
         elif frac > fracmax and frac<fracdown: thisval = 1.0
         elif frac >= fracdown and frac<fracoff:
             thisval = 1+mdown*(frac-fracdown)
         else: thisval = 0.0
         self.green.append( thisval )

   def get_color(self, val, valmin, valmax):
       # map val to a range from 0 to 1
       if iterable(val):
          s = "val must be a scalar.  Perhaps you meant to call get_colors?"
          raise ValueError, s
       #print valmin, valmax
       ind = self.indmax*(val-valmin)/(valmax-valmin)
       return self.rgbs[self._bound_ind(ind)]


   def _bound_ind(self, ind):
      if ind < 0: return 0
      if ind > self.indmax: return self.indmax
      return int(ind)
      

   def get_colors(self, vals, valmin=None, valmax=None):
      # map Numeric array vals to colors
      if valmin is None: valmin = min(vals)
      if valmax is None: valmax = max(vals)
      if valmin==valmax: return self.rgbs[0]
      ind = (self.N-1.0)/(valmax-valmin)*(vals-valmin)
      return [self.rgbs[self._bound_ind(i)] for i in ind]
