/***************************************************************************
 *   Copyright (C) 2005 by Jakub Stachowski                                *
 *   qbast@go2.pl                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "startdialog.h"
#include <klocale.h>
#include <kuser.h>
#include <klineedit.h>
#include <qradiobutton.h>

StartDialog::StartDialog(QWidget *parent, const char *name)
	: KDialogBase(parent, name, true, i18n("Start session"),Ok),
	  browser("_mateedit._tcp",0,true)
{
	m_main = new StartDialogBase(this);
	setMainWidget(m_main);
	connect(&browser,SIGNAL(serviceAdded(DNSSD::RemoteService::Ptr)),this,
		 SLOT(serviceAdded(DNSSD::RemoteService::Ptr)));
	connect(&browser,SIGNAL(serviceRemoved(DNSSD::RemoteService::Ptr)),this,
		 SLOT(serviceRemoved(DNSSD::RemoteService::Ptr)));
	connect(m_main->guestButton,SIGNAL(toggled(bool)),this,SLOT(enableWidgets()));
	connect(m_main->sessions,SIGNAL(highlighted(int)),this,SLOT(enableWidgets()));
    connect(m_main->sessions,SIGNAL(highlighted(int)),m_main->hostButton,SLOT(toggle()));
    connect(m_main->sessions,SIGNAL(highlighted(int)),m_main->guestButton,SLOT(toggle()));
//	connect(m_main->sessions,SIGNAL(executed(QListBoxItem*)),this,SLOT(slotOk()));
	browser.startBrowse();
    KUser user;

    m_main->nameEdit->setText(user.loginName());
}


StartDialog::~StartDialog()
{
}


#include "startdialog.moc"

void StartDialog::serviceAdded(DNSSD::RemoteService::Ptr srv)
{
	new ServiceItem(m_main->sessions,srv);
	enableWidgets();
}


void StartDialog::serviceRemoved(DNSSD::RemoteService::Ptr srv)
{
	delete m_main->sessions->findItem(srv->serviceName(),0);
	enableWidgets();
}

ServiceItem::ServiceItem(QListBox* parent, DNSSD::RemoteService::Ptr srv)
	: QListBoxText(parent, srv->serviceName()), service(srv)
{}

void StartDialog::enableWidgets()
{
    if ( ! m_main->guestButton->isChecked())
    {
        enableButtonOK(true);
    }
	else
	{
		enableButtonOK(m_main->sessions->selectedItem()!=0);
    }


}
