; m4 macro definitions for functions in Mathomatic.
define(`sqrt', `(($1)^.5)'); sqrt(x) = square root of x
define(`exp', `(e^($1))'); exp(x) = e^x
define(`pow', `(($1)^($2))'); pow(x, y) = x^y
define(`abs', `(|($1)|)'); abs(x) = absolute value = |x|
define(`fact', `(($1)!)'); fact(x) = factorial = x!

; Standard trigonometry functions as complex exponentials:
define(`sin', `((e^(i*($1))-e^(-i*($1)))/(2i))'); sine
define(`cos', `((e^(i*($1))+e^(-i*($1)))/2)'); cosine
define(`tan', `((e^(i*($1))-e^(-i*($1)))/(i*(e^(i*($1))+e^(-i*($1)))))'); tangent
define(`cot', `(i*(e^(i*($1))+e^(-i*($1)))/(e^(i*($1))-e^(-i*($1))))'); cotangent
define(`sec', `(2/(e^(i*($1))+e^(-i*($1))))'); secant
define(`csc', `(2i/(e^(i*($1))-e^(-i*($1))))'); cosecant

; Hyperbolic trigonometry functions:
define(`sinh', `((e^($1)-e^-($1))/2)')
define(`cosh', `((e^($1)+e^-($1))/2)')
define(`tanh', `((e^($1)-e^-($1))/(e^($1)+e^-($1)))')
define(`coth', `((e^($1)+e^-($1))/(e^($1)-e^-($1)))')
define(`sech', `(2/(e^($1)+e^-($1)))')
define(`csch', `(2/(e^($1)-e^-($1)))')
echo Functions are now available.
