/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include <kmessagebox.h>

#include <klocale.h>
#include <kpopupmenu.h>
#include <qdatetime.h>
#include <qtextbrowser.h>
#include <qprogressbar.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qptrlist.h>
#include <qcursor.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include "programview.h"
#include "programitem.h"
#include "channelitem.h"
#include "mainwidget.h"
#include "program.h"
#include "favouritemaster.h"
#include "completeview.h"
//-----------------------------------------------------------------------------------------------------------------------
CompleteView::CompleteView(MainWidget *parent, ProgramMaster *programMaster, KListView *lv, QPtrList<Program> *programs, QWidget *frame)
	: BaseView(parent, programMaster, lv, programs, frame) { }
//-----------------------------------------------------------------------------------------------------------------------
//void CompleteView::loadSettings(KConfig *cfg) { }
//-----------------------------------------------------------------------------------------------------------------------
//void CompleteView::saveSettings(KConfig *cfg) { }
//-----------------------------------------------------------------------------------------------------------------------
bool CompleteView::rebuild()
{
	QDate today(QDate::currentDate());
	Program *program;
	QString start;
	int daysTo;

	updateDesc();
	saveSelection();
	m_lv->clear();
	for(uint i=0; i<m_programs->count(); i++) {
		program = m_programs->at(i);
		daysTo = today.daysTo(program->startDT().date());
		if(daysTo == 0) {
			start = program->startDT().toString("hh:mm");
		} else {
			start = program->startDT().toString("hh:mm  ddd");
			if(daysTo > 0)
				start += ("  (+" + QString::number(daysTo) + ") ");
			else
				start += ("  (" + QString::number(daysTo) + ") ");
		}
		new ProgramItem(m_parent, m_lv, program, start, program->title(), program->duration().toString("h:mm"), program->channel()->customName());
	}
	m_lv->sort();
	if(!refresh())
		return(false);
	restoreSelection();
	updateDesc();
	return(true);
}
//-----------------------------------------------------------------------------------------------------------------------
void CompleteView::filter(ProgramItem *pi)
{
	BaseView::filter(pi);
	if(pi->isVisible())
		hideNonFavs(pi);
}
//-----------------------------------------------------------------------------------------------------------------------
void CompleteView::showPopupMenu(KListView*, QListViewItem *item, const QPoint&)
{
	KPopupMenu *programMenu = new KPopupMenu(m_parent);
	FavouriteMaster *favouriteMaster = m_parent->favouriteMaster();
	BlistMaster *blistMaster = m_parent->blistMaster();
	Program *program = NULL;

	if(item) program = ((ProgramItem*)item)->program();

	if(program && favouriteMaster->isFavourite(program->title())) {
		programMenu->insertItem(i18n("Remove from Favourites"), favouriteMaster, SLOT(removeFavourite()), Key_Space);
	} else {
		int a = programMenu->insertItem(i18n("Add to Favourites"), favouriteMaster, SLOT(addFavourite()), Key_Space);
		programMenu->setItemEnabled(a, (item?true:false));
	}
	programMenu->insertSeparator();
	int b = programMenu->insertItem(i18n("Blacklist"), blistMaster, SLOT(addBlacklist()), CTRL+Key_B);
	programMenu->setItemEnabled(b, (item?true:false));
	programMenu->insertSeparator();
	
	programMenu->setCheckable(true);
	int h = programMenu->insertItem(i18n("Hide Past"), this, SLOT(toggleHidePast()), CTRL+Key_H);
	int f = programMenu->insertItem(i18n("Favourites Only"), this, SLOT(toggleFavsOnly()), CTRL+Key_F);
	programMenu->setItemChecked(h, m_hidePast);
	programMenu->setItemChecked(f, m_favsOnly);
	programMenu->insertSeparator();
	programMenu->insertItem(i18n("Day View..."), m_parent, SLOT(setView(int)), Key_F1, 0);
	int u = programMenu->insertItem(i18n("Full View..."), m_parent, SLOT(setView(int)), Key_F2, 2);
	programMenu->insertItem(i18n("Search View..."), m_parent, SLOT(setView(int)), Key_F3, 1);
	programMenu->setItemEnabled(u, false);
	programMenu->insertSeparator();
	int fo = programMenu->insertItem(i18n("Forum..."), m_parent, SLOT(setView(int)), Key_F4, 3);
	programMenu->setItemEnabled(fo, (item?true:false));

	programMenu->exec(QCursor::pos());

	delete programMenu;
}
//-----------------------------------------------------------------------------------------------------------------------
void CompleteView::aboutToShow()
{
	updateDesc();
	if(!refresh())
		rebuild();
}
//-----------------------------------------------------------------------------------------------------------------------
