/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#ifndef __PARSER_H__
#define __PARSER_H__
//-----------------------------------------------------------------------------------------------------------------------
#include <qstring.h>
#include <qptrlist.h>
#include <qxml.h>
#include "channel.h"
#include "program.h"
//-----------------------------------------------------------------------------------------------------------------------
enum Element { NONE, CHANNEL, DISPLAYNAME, PROGRAM, TITLE, SUBTITLE, DESC, CATEGORY, ACTOR, DIRECTOR, DATE, ASPECT, EPISODE, ICON };
//-----------------------------------------------------------------------------------------------------------------------
class Parser : public QXmlDefaultHandler
{
public:
	Parser(QPtrList<Channel> *channels, QPtrList<Program> *programs, QStringList *categories);

	bool startElement(const QString& uri, const QString& localName, const QString& qName, const QXmlAttributes& attr);
	bool endElement(const QString&, const QString&, const QString&);
	bool characters(const QString& ch);

private:
	QPtrList<Channel>* m_channels;
	QPtrList<Program>* m_programs;
	QStringList *m_categories;
	Channel *m_channel;
	Program *m_program;
	Element m_element;

};
//-----------------------------------------------------------------------------------------------------------------------
#endif
//-----------------------------------------------------------------------------------------------------------------------
