/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include <kcolorbutton.h>
#include <qcolor.h>
#include <qstyle.h>
#include "programmaster.h"
#include "programitem.h"
#include "mainwidget.h"
#include "channel.h"
//-----------------------------------------------------------------------------------------------------------------------
ProgramItem::ProgramItem(MainWidget *parent, QListView *lv, Program *program, QString time, QString title, QString duration, QString channel)
	: QListViewItem(lv, " "+time+" ", " "+title+" ", " "+duration+" ", " "+channel+" ")
	, m_time(program->startDT())
{
	m_parent = parent;
	m_program = program;
	
/*	Channel *ch = m_parent->channelMaster()->channel(m_program->channelId());
	if(ch && !ch->image().isNull()) {
		m_pixmap.convertFromImage(ch->image().smoothScale(height()-2, height()-2));
		setPixmap(1, m_pixmap);
	}
*/
//	qDebug("starting = \"%s\" == \"%s\"", time.ascii(), program->start().ascii());
}
//-----------------------------------------------------------------------------------------------------------------------
void ProgramItem::paintCell(QPainter *p, const QColorGroup & cg, int column, int width, int /*align*/)
{
	int margin = m_parent->lv_program->itemMargin();
	QRect box(margin, margin, width-margin*2, height()-margin*2);
	QColor bgColor, fgColor, hourLine(140, 140, 140), colCol(220, 220, 220);
	bool isOn = ProgramMaster::onNow(m_program);
	
	if(isSelected()) {
		bgColor = cg.highlight();
	} else {
		bgColor = fgColor = cg.base();
		if(m_parent->prefs()->cb_past->isChecked() && ProgramMaster::hasEnded(m_program))
			bgColor = fgColor = m_parent->prefs()->kcb_past->color();
		if(m_parent->prefs()->cb_present->isChecked() && ProgramMaster::onNow(m_program))
			bgColor = fgColor = m_parent->prefs()->kcb_present->color();
		if(m_parent->prefs()->cb_future->isChecked() && !ProgramMaster::hasStarted(m_program))
			bgColor = fgColor = m_parent->prefs()->kcb_future->color();
	}
	p->fillRect(0, 0, width, height(), bgColor);

	if(column == 1 && !isSelected() && m_parent->prefs()->cb_favourite->isChecked() && m_parent->favouriteMaster()->isFavourite(m_program->title())) {
		bgColor = fgColor = m_parent->prefs()->kcb_favourite->color();
		p->fillRect(0, 0, width, height(), bgColor);
	}

	if(m_parent->prefs()->cb_progress->isChecked() && column == 1 && /* !isSelected() && */ isOn) {
		double pDone = ProgramMaster::elapsedPercentage(m_program);
		if(isSelected())
			bgColor = fgColor = cg.highlight().light(120);
		else
			bgColor = fgColor = m_parent->prefs()->kcb_progress->color();
		p->fillRect(0, 0, (int)(width*(pDone)), height(), bgColor);

		p->setPen(bgColor.dark(106));
		p->drawLine(0, height()-1, (int)(width*(pDone)), height()-1);
		p->drawLine((int)(width*(pDone)), 0, (int)(width*(pDone)), height());
		p->setPen(bgColor.light(106));
		p->drawLine(0, 0, (int)(width*(pDone)), 0);
		p->drawLine(0, 0, 0, height());
	}

	if((listView() == m_parent->lv_program && m_parent->prefs()->cb_timesep->isChecked() && listView()->sortColumn() == 0 && itemAbove() && (program()->startDT().time().hour() != ((ProgramItem*)itemAbove())->program()->startDT().time().hour())) ||
		(listView() != m_parent->lv_program && m_parent->prefs()->cb_timesep->isChecked() && listView()->sortColumn() == 0 && itemAbove() && (program()->startDT().date().day() != ((ProgramItem*)itemAbove())->program()->startDT().date().day()))) {
		p->setPen(m_parent->prefs()->kcb_timesep->color());
		p->drawLine(0, 0, width-1, 0);
	}
	if(m_parent->prefs()->cb_colsep->isChecked()) {
		p->setPen(m_parent->prefs()->kcb_colsep->color());
		p->drawLine(width-1, 0, width-1, height()-1);
	}

	if(column > 0 || !itemAbove() || (itemAbove() && text(0).compare(itemAbove()->text(0)) != 0))
		fgColor = cg.text();
	if(isSelected())
		fgColor = cg.highlightedText();

	p->setPen(fgColor);
	p->drawText(box, AlignVCenter, text(column));
	
//	if(isOn && m_parent->cb_chanicons->isChecked() && !m_pixmap.isNull())
//		setPixmap(1, m_pixmap);
}
//-----------------------------------------------------------------------------------------------------------------------
int ProgramItem::compare(QListViewItem *with, int col, bool ascending) const
{
	ProgramItem *pi = (ProgramItem*)with;

	if(col > 0)
		return(key(col, ascending).compare(with->key(col, ascending)));

	if(program()->startDT() == pi->program()->startDT()) {
		return(channelSort(pi));
	} else if(program()->startDT() > pi->program()->startDT()) {
		return(1);
	} else {
		return(-1);
	}
}
//-----------------------------------------------------------------------------------------------------------------------
int ProgramItem::channelSort(ProgramItem *pi) const
{
	Channel *chA = program()->channel();
	Channel *chB = pi->program()->channel();

	if(!chA || !chB) return(0);
	if(chA->prio() == chB->prio())
		return(0);
	if(chA->prio() < chB->prio())
		return(1);
	return(-1);
}
//-----------------------------------------------------------------------------------------------------------------------
