/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#ifndef __PROGRAMVIEW_H__
#define __PROGRAMVIEW_H__
//-----------------------------------------------------------------------------------------------------------------------
#include <klistview.h>
#include <qcombobox.h>
#include "programmaster.h"
#include "programitem.h"
#include "baseview.h"
//-----------------------------------------------------------------------------------------------------------------------
class MainWidget;
//-----------------------------------------------------------------------------------------------------------------------
class ProgramView : public BaseView
{
	Q_OBJECT
public:
	ProgramView(MainWidget *parent, ProgramMaster *programMaster, KListView *lv, QPtrList<Program> *programs, QWidget *frame);
	~ProgramView() { m_dates.clear(); }

//	virtual void loadSettings(KConfig *cfg);
//	virtual void saveSettings(KConfig *cfg);

	virtual void filter(ProgramItem *pi);
	virtual void newDay() { rebuildCBDates(); }
	virtual void aboutToShow();
	virtual void preParse() { m_lv->clear(); m_date->clear(); }
	virtual void postParse() { rebuildCBDates(); }

	void rebuildCBDates();
	void daystartPassed();

public slots:
	virtual void showPopupMenu(KListView*, QListViewItem *item, const QPoint&);
	virtual bool rebuild();
	void yesterdayClicked();
	void todayClicked();
	void tomorrowClicked();

private:
	int m_todayIdx;			// index number of today in cb_date
	QPtrList<QDate> m_dates;
	QComboBox *m_date;

};
//-----------------------------------------------------------------------------------------------------------------------
#endif
//-----------------------------------------------------------------------------------------------------------------------
