""" Displays the new folder wizard. """


# Enthought library imports.
from enthought.pyface.api import GUI, OK

# Local imports.
from enthought.envisage.project.wizard.new_folder_wizard import FolderFactory
from enthought.envisage.project.wizard.new_folder_wizard import NewFolderWizard
from new_resource_action import NewResourceAction


class NewFolderAction(NewResourceAction):
    """ Displays the new folder wizard. """

    ###########################################################################
    # 'Action' interface.
    ###########################################################################

    def perform(self, event):
        """ Performs the action. """

        # Get the parent folder (this will be None if the action is invoked
        # via the 'File' menu and no folder is selected in the navigator
        # view).
        parent_folder = self._get_default_folder()
        
        # If the action was invoked via the context menu on a folder then
        # we can create the new folder and edit its name 'inplace'.
        if parent_folder is not None and hasattr(event, 'widget'):
            # Make sure that the folder that the resource is to be created in
            # is expanded.
            event.widget.expand(parent_folder)
                        
            # The context to create the folder in.
            context = parent_folder.obj

            # Generate a name that is unique within the context.
            default_name = self._get_default_name('New Folder', context)

            # Create the folder.
            context.create_subcontext(default_name)

            # Lookup the binding.
            binding = parent_folder.obj.lookup_binding(default_name)

            # Start a label edit.
            GUI.invoke_later(event.widget.edit_label, *(binding,))

        # Otherwise, the action was invoked via the 'File' menu.
        else:
            # The factory used to create the folder.
            factory = FolderFactory(parent_folder=parent_folder)
        
            # Open the wizard.
            wizard = NewFolderWizard(
                parent=self.window.control, factory=factory
            )
            if wizard.open() == OK:
                # Create the resource!                
                wizard.create_resource()
            
        return

    ###########################################################################
    # Private interface.
    ###########################################################################

    def _get_default_name(self, prefix, context):
        """ Returns a name that is not already bound in a context. """

        names = context.list_names('')
        name  = prefix
        
        id = 2
        while name in names:
            name = '%s (%d)' % (prefix, id)
            id += 1
            
        return name
    
#### EOF ######################################################################
