""" A folder in a project. """


# Enthought library imports.
from enthought.envisage.resource import ResourceContext
from enthought.traits.api import Instance


class Folder(ResourceContext):
    """ A folder in a project. """

    # The project that the folder belongs to.
    project = Instance('enthought.envisage.project.Project')
    
    ###########################################################################
    # 'Folder' interface.
    ###########################################################################

    def create_folder(self, name):
        """ Creates a folder with the specified name. """

        folder = self.create_subcontext(name)

        return folder

    def create_resource(self, name, value):
        """ Creates a resource with the specified name and value. """

        self.bind(name, value)
        
        return

    ###########################################################################
    # Protected 'Context' interface.
    ###########################################################################

    def _context_factory(self, name, path=None):
        """ Create a sub-context. """

        if path is None:
            path = os.path.join(self.path, name)

        folder = Folder(
            path=path, project=self.project, environment=self.environment
        )

        return folder
    
##### EOF #####################################################################
