""" Abstract base class for all resource factories. """


# Enthought library imports.
from enthought.naming.api import Binding
from enthought.traits.api import Instance, HasTraits, Str


class ResourceFactory(HasTraits):
    """ Abstract base class for all resource factories. """

    #### 'ResourceFactory' interface ##########################################
    
    # The folder to create the resource in.
    parent_folder = Instance(Binding)

    # The name of the resource to create.
    name = Str

    ###########################################################################
    # 'ResourceFactory' interface.
    ###########################################################################

    def create_resource(self):
        """ Creates the resource. """

        raise NotImplementedError

#### EOF ######################################################################
