""" A wizard page for selecting a wizard! """


# Major package imports.
import wx

# Enthought library imports.
from enthought.naming.api import Binding, Context
from enthought.naming.ui.api import NamingTree, NamingTreeModel
from enthought.pyface.api import HeadingText
from enthought.pyface.wizard.api import WizardPage
from enthought.traits.api import Any, Instance


class WizardSelectionPage(WizardPage):
    """ A wizard page for selecting a wizard!

    This is the first page in the 'new resource' wizard.

    """

    #### 'WizardSelectionPage' interface ######################################

    # The object that the wizard is configuring.
    obj = Any

    # The root of the naming context that provides the wizards that the user
    # can choose from.
    root = Instance(Context)

    ###########################################################################
    # 'WizardPage' interface.
    ###########################################################################

    def create_page(self, parent):
        """ Creates the wizard page. """

        panel = wx.Panel(parent, -1, style=wx.CLIP_CHILDREN)
        sizer = wx.BoxSizer(wx.VERTICAL)
        panel.SetSizer(sizer)
        panel.SetAutoLayout(True)

        # The 'pretty' title bar ;^)
        title = HeadingText(panel, text='Select a type of item')
        sizer.Add(title.control, 0, wx.EXPAND | wx.BOTTOM, 5)

        # The tree used to select the wizard.
        tree = self._create_tree(panel)
        tree.SetSizeHints(-1, 250)    # fixme - move this into Tree (or Widget)
        sizer.Add(tree, 1, wx.EXPAND)

        # Resize the panel to match the sizer's minimum size.
        sizer.Fit(panel)

        return panel

    ###########################################################################
    # Private interface.
    ###########################################################################

    def _create_tree(self, parent):
        """ Creates the wizard selection tree. """

        model = NamingTreeModel(root=Binding(name='root', obj=self.root))

        tree = NamingTree(parent, model=model, show_root=False)
        tree.expand_all()
        tree.on_trait_change(self._on_selection_changed, 'selection')

        return tree.control

    #### Trait event handlers #################################################

    def _on_selection_changed(self, selection):
        """ Called when a node in the tree is selected. """

        # The tree is in single selection mode.
        if len(selection) > 0:
            # Wizards are grouped into categories (ie. 'Context's).  The user
            # cannot proceed if a category is selected, only when an actual
            # wizard is selected.
            if isinstance(selection[0].obj, Context):
                self.obj.wizard = None

            else:
                self.obj.wizard = selection[0].obj

        # The page is complete when a wizard is selected.
        self.complete = self.obj.wizard is not None

        return

#### EOF ######################################################################
