""" The resource type for Numeric arrays. """


# Major package imports.
from enthought.util import numerix

# Enthought library imports.
from enthought.envisage.resource import ObjectResourceType

# Local imports.
from array_node_type import ArrayNodeType


class ArrayResourceType(ObjectResourceType):
    """ The resource type for Numeric arrays. """

    ###########################################################################
    # 'ResourceType' interface.
    ###########################################################################

    #### Initializers #########################################################

    def _node_type_default(self):
        """ Initializes the node type. """

        return ArrayNodeType(resource_type=self)

    #### Methods ##############################################################

    def is_type_for(self, obj): 
        """ Returns True if the resource type 'recognizes' an object. """

        return type(obj) is numerix.ArrayType

##### EOF #####################################################################
