""" The resource type for Python bools. """


# Enthought library imports.
from enthought.envisage.resource import ObjectResourceType
from enthought.traits.api import Bool

# Local imports.
from bool_node_type import BoolNodeType


class BoolResourceType(ObjectResourceType):
    """ The resource type for Python bools. """

    #### 'ResourceType' interface #############################################

    # A trait that describes the kind of domain object that the type
    # represents.
    type = Bool

    ###########################################################################
    # 'ResourceType' interface.
    ###########################################################################

    #### Initializers #########################################################

    def _node_type_default(self):
        """ Initializes the node type. """

        return BoolNodeType(resource_type=self)

##### EOF #####################################################################
