""" The resource type for folders. """


# Standard library imports.
import cPickle
from os.path import join

# Enthought library imports.
from enthought.io import File
from enthought.naming.api import Context
from enthought.traits.api import Instance

# Local imports.
from folder_node_type import FolderNodeType
from resource_type import ResourceType


class FolderResourceType(ResourceType):
    """ The resource type for folders.

    A 'Folder' is just a naming context.

    """

    #### 'ResourceType' interface #############################################

    # A trait that describes the kind of domain object that the type
    # represents.
    type = Instance(Context)

    ###########################################################################
    # 'ResourceType' interface.
    ###########################################################################

    #### Initializers #########################################################

    def _node_type_default(self):
        """ Initializes the node type. """

        return FolderNodeType(resource_type=self)

    #### Methods ##############################################################

    def clone(self, obj):
        """ Returns a clone of an object. """

        return cPickle.loads(cPickle.dumps(obj))

    def copy(self, context, name, obj):
        """ Copies a resource into the specified context. """

        # fixme: Is it OK that this method assumes a 'PyFSContext'? I think
        # NOT!  We need to extend the context API to support the notion of
        # copying a context/object... This is where is starts to look like
        # the NetBeans file system abstraction was a better fit maybe, although
        # an extended context API qould just end up looking startlingly
        # similar.  The file system notion might also be better as it is
        # more familiar?
        #
        # Create a sub-context of the target context.
        sub = context.create_subcontext(name)

        # fixme: Hack to remove the folder so that copy will work!
        destination = File(sub.path)
        destination.delete()

        # Copy the folder contents.
        source = File(obj.path)
        source.copy(destination)

        # Refresh the new subcontext to reflect its contents.
        sub.refresh()
        
        return

#### EOF ######################################################################
