""" The resource type for Python lists. """


# Enthought library imports.
from enthought.envisage.resource import ObjectResourceType
from enthought.naming.adapter import ListContextAdapterFactory
from enthought.traits.api import List

# Local imports.
from list_node_type import ListNodeType


class ListResourceType(ObjectResourceType):
    """ The resource type for Python lists. """

    #### 'ResourceType' interface #############################################

    # A trait that describes the kind of domain object that the type
    # represents.
    type = List

    ###########################################################################
    # 'ResourceType' interface.
    ###########################################################################

    #### Initializers #########################################################

    def _node_type_default(self):
        """ Initializes the node type. """

        return ListNodeType(resource_type=self)

    def _context_adapter_factory_default(self):
        """ Initializes the context adapter factory. """

        return ListContextAdapterFactory()

##### EOF #####################################################################
