""" The node manager used by the resource tree model. """


# Enthought library imports.
from enthought.envisage.resource import ResourceManager
from enthought.naming.ui.api import NamingNodeManager
from enthought.traits.api import Instance


class ResourceTreeNodeManager(NamingNodeManager):
    """ The node manager used by the resource tree model.

    This simply adapts the resource manager to the 'NodeManager' interface.

    """

    #### 'ResourceTreeNodeManager' interface ##################################

    # The resource manager that we are adapting.
    resource_manager = Instance(ResourceManager)

    ###########################################################################
    # 'NodeManager' interface.
    ###########################################################################

    def get_node_type(self, node):
        """ Returns the node's type. """

        resource_type = self.resource_manager.get_type_of(node.obj)
        if resource_type is None:
            raise ValueError("No resource type found for node " % str(node))

        return resource_type.node_type
    
#### EOF ######################################################################
