""" A location within the layout where a PartPane may be added.

LayoutPart is an internal Envisage class.  Users of Envisage should not have to
directly use, modify, or extend this class.  LayoutParts are managed by the
PageLayout of the WorbenchWindow and are used for placement of Views.  

"""

# Major package imports.
import wx


# Enthought library imports.
from enthought.traits.api import Any, Bool, Dict, HasTraits

# Local imports.
from part_pane import PartPane


class LayoutPart(HasTraits):
    """ A location within the layout where a PartPane may be added. """
    
    # The toolkit-specific control that represents the layout part.
    control = Any

    # The parent window.
    window = Any

    # The list of child panes.
    panes = Dict

    # Is the layout part empty?
    empty = Bool(True)
    
    ###########################################################################
    # 'LayoutPart' interface.
    ###########################################################################

    def create_control(self, parent):
        """ Create the control in the specified parent. """

        self.control = wx.Notebook(parent, -1, style=wx.CLIP_CHILDREN)

###############################################################################
###############################################################################
###############################################################################
# WXFIXME : If we want to be able to restore hidden panes, we have to
#           reparent them to some other window and back again. :-{ 
###############################################################################
###############################################################################
###############################################################################
        self._hack = wx.Window(parent, -1, size=(0,0))
        
        return self.control

    def create_part_pane(self, name):
        """ Factory method to create a child pane with the given name. """

        return PartPane(name=name, layout=self)

    def show_pane(self, pane):
        if not self.panes.has_key(pane):

###############################################################################
###############################################################################
###############################################################################
# WXFIXME : If we want to be able to restore hidden panes, we have to
#           reparent them to some other window and back again. :-{ 
###############################################################################
###############################################################################
###############################################################################
            pane.control.Reparent(self.control)
            self.control.AddPage(pane.control, pane.name)
            self.panes[pane] = pane.control

            self.empty = False

        return

    def hide_pane(self, pane):
        """ Hide the part pane. """
        
        pane_control = self.panes[pane]
        if pane_control is not None:
            # Find the page index in the notebook so we can remove the page.
            count = self.control.GetPageCount()
            for index in range(count):
                page = self.control.GetPage(index)
                if page == pane_control:
                    self.control.RemovePage(index)

###############################################################################
###############################################################################
###############################################################################
# WXFIXME : If we want to be able to restore hidden panes, we have to
#           reparent them to some other window and back again. :-{ 
###############################################################################
###############################################################################
###############################################################################
                    page.Reparent(self._hack)

                    del self.panes[pane]
                    if len(self.panes) == 0:
                        self.empty = True

                    break

        return

#### EOF ######################################################################
