""" A plugin that offers a UI for user preferences. """


# Enthought library imports.
from enthought.envisage import ExtensionItem, ExtensionPoint, PluginDefinition
from enthought.traits.api import List, Str

# Plugin definition imports.
from enthought.envisage.ui.ui_plugin_definition import \
     Action, Group, Menu, UIActions, UIViews, View


###############################################################################
# Extension points.
###############################################################################

#### Preference pages #########################################################

class Page(ExtensionItem):
    """ A page in the preference dialog. """

    # The page's unique identifier.
    id = Str

    # The page name.
    name = Str

    # The category that the page belongs to.
    category = Str

    # The name of the class that implements the page.
    class_name = Str

    # The Id of the help topic for the page.
    help_id = Str
    
    
class PreferencePages(ExtensionPoint):
    """ Allows for contributions to the preferences dialog. """
    
    # Preference page contributions.
    pages = List(Page)
    
###############################################################################
# Extensions.
###############################################################################

#### Preference pages #########################################################

workbench_preference_page = Page(
    id         = "enthought.envisage.ui.preference.UIPreferencePage",
    class_name = "enthought.envisage.ui.preference.UIPreferencePage",
    name       = "Workbench",
    category   = "",
    help_id    = "enlib|HID_Workbench_Preferences",
)

preference_pages = PreferencePages(
    pages = [
        workbench_preference_page
    ]
)

#### Menus/Actions ############################################################

tools_menu = Menu( 
    id     = "ToolsMenu",
    name   = "&Tools",
    path   = "ToolsGroup",
    groups = [
    Group(id="Start"),
    Group(id="End"),
    ]
)

edit_preferences_action = Action(
    id        ="enthought.envisage.ui.preference.action.EditPreferencesAction",
    class_name="enthought.envisage.ui.preference.action.EditPreferencesAction",
    name          = "&Preferences",
    image         = "images/edit_preferences.png",
    description   = "Edit user preferences",
    tooltip       = "Edit user preferences",
    menu_bar_path = "ToolsMenu/End",
    tool_bar_path = "",
)

ui_actions = UIActions(
    menus = [tools_menu],
    
    actions = [
        edit_preferences_action,
    ]
)

###############################################################################
# The plugin definition!
###############################################################################

PluginDefinition(
    # The plugin's globally unique identifier.
    id = "enthought.envisage.ui.preference",
    
    # The name of the class that implements the plugin.
    class_name = "enthought.envisage.ui.preference.PreferencePlugin",

    # General information about the plugin.
    name          = "Envisage Preference UI Plugin",
    version       = "1.0.0",
    provider_name = "Enthought Inc",
    provider_url  = "www.enthought.com",
    enabled       = True,
    autostart     = False,
    
    # The Id's of the plugins that this plugin requires.
    requires = ["enthought.envisage.ui"],

    # The extension points offered by this plugin.
    extension_points = [PreferencePages],
    
    # The contributions that this plugin makes to extension points offered by
    # either itself or other plugins.
    extensions = [ui_actions, preference_pages]
)

#### EOF ######################################################################
