""" The entry point for an Envisage application. """


# Standard library imports.
import sys

# Enthought library imports.
from enthought.envisage.api import Application

# Local imports.
from plugin_definitions import PLUGIN_DEFINITIONS


def run(argv=sys.argv):
    """ Creates and starts the application. """

    # Create an Envisage application.
    application = Application(
         # The command line arguments.
         argv = argv,
         
         # The application's GLOBALLY unique identifier.
         id = 'enthought.envisage.examples.hello_world',
         
         # The absolute filenames of all of the plugin definitions used in
         # the application (a list of strings).
         plugin_definitions = PLUGIN_DEFINITIONS,
         
         # Does the application require a GUI?
         requires_gui = False
    )

    # Start the application!
    application.start()

    # Since this application has no event loop (i.e., it is not a GUI or a
    # daemon etc), then all of the actual work is done in the call to
    # 'application.start'. We can now stop the application to give all of the
    # plugins a chance to close down cleanly and to do any housekeeping etc.
    application.stop()

    return


# Application entry point.
if __name__ == '__main__':
    run()

#### EOF ######################################################################
