""" Adapts a Foo to a Bar. """


# Enthought library imports.
from enthought.traits.api import HasTraits, Instance

# Acme library imports.
from enthought.envisage.examples.misc.bar import Bar
from enthought.envisage.examples.misc.foo import Foo


class FooBarAdapter(HasTraits):
    """ Adapts a Foo to a Bar. """

    # The object that we are adapting.
    adaptee = Instance(Foo)

    ###########################################################################
    # 'Bar' interface.
    ###########################################################################

    def bar(self):
        """ bar! """
        
        return self.adaptee.foo()

#### EOF ######################################################################
