""" An example perspective. """


# Enthought library imports.
from enthought.envisage.workbench.api import Perspective


class BazPerspective(Perspective):
    """ An example perspective.

    This example shows that you can get full control of the layout of the
    perspective by creating a sub-class and overriding the 'create' method.

    """

    ###########################################################################
    # 'Perspective' interface.
    ###########################################################################
    
    def create(self, window_layout):
        """ Creates the perspective in the specified window layout.

        Override this method if you want to have complete control over how
        the perspective is created.  For most cases you should just be able
        to set the 'contents' trait to layout the required views.

        """

        # If the perspective has specific contents then we add just those.
        if len(self.contents) > 0:
            self._add_contents(window_layout, self.contents)

        # Otherwise, we add all of the views defined in the application at
        # their default positions realtive to the editor area.
        else:
            self._add_all(window_layout)
        
        return
    
#### EOF ######################################################################
