/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */
 
#ifndef __DVB_SI_H__
#define __DVB_SI_H__

#include "dvb_demuxer.h"
#include <vector>
#include <map>
#include <iostream>
#include <fstream>

#define CRC_BYTE_SIZE			4
#define DVB_SECTION_BUFFER_SIZE	16*1024

#define PAT_PID		0x00
#define EIT_PID		0x12

#define PAT_ID		0x00
#define PMT_ID		0x02
#define EIT_ID		0x4E

class ShortEvent
{
public:
	ShortEvent();

	u_int      event_id;
	u_long     start_time_MJD;  // 16
	u_long     start_time_UTC;  // 24
	u_long     duration;
	u_int      running_status;
	u_int      free_CA_mode;
	
	long dur_hour;
	long dur_min;
	long dur_sec;
	
	long start_year;
	long start_month;
	long start_day;
	
	long start_hour;
	long start_min;
	long start_sec;
	
	String title;
	String description;
};

class DvbEventInformationSection
{
public:
	u_int table_id;
	u_int section_syntax_indicator;
	u_int service_id;
	u_int version_number;
	u_int current_next_indicator;
	u_int section_number;
	u_int last_section_number;
	u_int transport_stream_id;
	u_int original_network_id;
	u_int segment_last_section_number;
	u_int last_table_id;
	unsigned long crc;
	std::vector<ShortEvent> short_events;
};

class ProgramAssociation
{
public:
	guint program_number;
	guint program_map_pid;
};

class ProgramAssociationSection
{
public:
	std::vector<ProgramAssociation> program_associations;
};

class ProgramMapSection
{
public:
	std::vector<guint> video_pids;
	std::vector<guint> audio_pids;
	std::vector<guint> subtitle_pids;
	std::vector<guint> teletext_pids;
	std::vector<guint> ac3_pids;
};

class DvbSectionParser
{
private:
	guchar buffer[DVB_SECTION_BUFFER_SIZE];
	String epg_encoding;
		
	gint find_descriptor(uint8_t tag, const unsigned char *buf, int descriptors_loop_len,
		const unsigned char **desc, int *desc_len);
	guint get_bits(const guchar* buffer, guint bitpos, gsize bitcount);
	String convert_iso6937(const guchar* buffer, gsize length);
	gsize decode_short_event (const guchar* buffer, ShortEvent& descriptor);
	gsize read_section(DvbDemuxer& demuxer);
public:
	DvbSectionParser();
	
	gsize get_text(String& s, const guchar* buffer);

	void parse_pas (DvbDemuxer& demuxer, ProgramAssociationSection& section);
	void parse_pms (DvbDemuxer& demuxer, ProgramMapSection& section);
	void parse_eis (DvbDemuxer& demuxer, DvbEventInformationSection& section);
};

#endif
