#ifndef __GTK_EPG_WIDGET__
#define __GTK_EPG_WIDGET__

#include <xml.h>
#include <gtk/gtk.h>
#include "epg.h"

class GtkEpgWidget
{
private:
	xmlNodePtr selected_event;
	gint offset;
	gsize span_hours;
	gsize span_minutes;
	gsize span_seconds;
	gsize last_number_rows;
	gsize last_number_columns;
	gsize number_rows;
	gsize number_columns;
	
	GtkWidget* vbox_epg;
	GtkWidget* table_epg;
	GtkWidget* scrolled_window_epg;
	GtkWidget* button_epg_previous;
	GtkWidget* button_epg_now;
	GtkWidget* button_epg_next;

	static void button_program_clicked(GtkButton* button, gpointer data);
	static void button_channel_name_clicked(GtkButton* button, gpointer data);
	static void button_epg_previous_clicked(GtkButton* button, gpointer data);
	static void button_epg_now_clicked(GtkButton* button, gpointer data);
	static void button_epg_next_clicked(GtkButton* button, gpointer data);

	String encode(const String& s);
	void set_offset(gint value);
	void update_table();
	GtkWidget* attach_button(const String& text, guint left_attach, guint right_attach, guint top_attach, guint bottom_attach);
	GtkWidget* attach_label(const String& text, guint left_attach, guint right_attach, guint top_attach, guint bottom_attach);
	void attach_widget(GtkWidget* widget, guint left_attach, guint right_attach, guint top_attach, guint bottom_attach);
	void create_channel_row(Channel& channel, guint row, gboolean selected, Epg& epg, guint now, guint start_time, guint end_time);

public:
	GtkEpgWidget();
	void update();
	void set_selected_event(xmlNodePtr event);
	void show();
	void hide();
	gboolean is_visible();
};

#endif
