/*
 * Copyright (C) 2008 Michael Lamothe
 *
 * This file is part of Me TV
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#ifndef __SCAN_DIALOG_H__
#define __SCAN_DIALOG_H__

#include <gtk/gtk.h>
#include "string.hh"
#include "mutex_lock.h"

class ScanDialog
{
private:
	GtkWidget* scan_dialog;
	GtkWidget* tree_view_select_region;
	GtkWidget* notebook_scan;
	GtkWidget* button_scan_dialog_next;
	GtkWidget* text_view_scan_progress;
	GtkTreeSelection* selection;
	gint standard_output;
	gint standard_error;
	int frontend_type;
	String text_buffer;
	GStaticRecMutex scan_mutex;
	String region;
	GThread* scan_thread;
	gboolean scan_complete;
	GPid pid;
	guint timeout_id;

	void scan();
	void on_region_selected();
	String get_initial_tuning_dir();

	static void button_scan_dialog_next_clicked(GtkButton* button, ScanDialog* scan_dialog);
	static void on_tree_view_select_region_row_activated(
		GtkTreeView* tree_view,
		GtkTreePath       *path,
		GtkTreeViewColumn *column,
		ScanDialog* scan_dialog);
	static gpointer scan_thread_func(gpointer data);
	static gpointer read_standard_output_func(gpointer data);
	static gpointer read_standard_error_func(gpointer data);
	static gboolean process_scan(gpointer data);

public:
	ScanDialog(int frontend_type);
	
	void append_text(const gchar* text);
	
	void show();
};

#endif
