<?php
// This script adds new movies and users

require_once('parse-imdb.php');

// Add a movie
if ($_SESSION['level'] == '3') {

?>

<br/>
<p class='subheading'>

<?php
   echo $module_text['addnewmovie'];
?>

</p>
<table class='admin'>

<?php

   // We only show the imdb url stuff if the server is connected 
   // to the internet

   if ($global_prefs['online'] == "on") {

?>

   <tr>
      <td align='right'>
         <p class='adminlabel'>

<?php

      echo $module_text['imdburl'], "&nbsp;&nbsp;\n";

?>

         </p>
      </td>
      <td align='left'>
         <form action='index.php' method='post'>
            <input type='hidden' name='module' value='movies'>
            <input type='hidden' name='do' value='add'>
            <input class='admintext' type='text' name='imdb_url' 
               size='50' maxlength='150' value='<?php echo "$imdb_url"?>'>
            <input type="hidden" name="r_imdb_url" 
               value="<?php echo $module_text['imdburlerror'];?>">
            <input type="hidden" name="action" value="movie">
            <input class="adminbutton" type="button" 
               value="<?php echo $module_text['getdetails'];?>" 
               onclick="check(form,form.elements.length)">
         </form>
      </td>
   </tr>

<?php
   };
?>

   <form enctype="multipart/form-data" action="index.php" method="post">
      <input type="hidden" name="module" value="movies">
      <input type="hidden" name="do" value="modify">
      <input type="hidden" name="action" value="addmovie">
      <input type="hidden" name="id" value="<?php echo "$id"?>">
      <input type="hidden" name="cover_art" value="<?php echo "$cover_art"?>">

      <tr>
         <td align="right" width="20%">
            <p class="adminlabel">

<?php
   echo $module_text['title'];
   echo "&nbsp;&nbsp;\n";
?>

            </p>
         </td>
         <td align="left">
            <input class="admintext" type="text" name="movie_title" 
               size="50" maxlength="50" value="<?php echo "$title" ?>">
            <input type="hidden" name="r_movie_title" 
               value="<?php echo $module_text['titlemissing'];?>">

<?php
   if (! is_null($title)) {
      echo "*";
   }
?>

         </td>
      </tr>

      <tr>
         <td align="right">
            <p class="adminlabel">

<?php 
   echo $module_text['director'];
   echo "&nbsp;&nbsp;\n";
?>

            </p>
         </td>
         <td align="left">
            <input class="admintext" type="text" name="movie_director" 
               size="50" maxlength="100" value="<?php echo $director;?>">

<?php
   if (! is_null($director)) {
      echo "*";
   }
?>

         </td>
      </tr>

      <tr>
         <td align="right">
            <p class="adminlabel">

<?php 
   echo $module_text['format'];
   echo "&nbsp;&nbsp;\n";
?>

            </p>
         </td>
         <td>
            <select class="adminlist" name="movie_format">

<?php
   require("modules/movies/lang/$lang.lists/formats.php");
   while (list ($key, $val) = each($formats_list)) {
      echo "<option value=\"$key\">$val</option>\n";
   };
?>

            </select>
         </td>
      </tr>
      <tr>
         <td align="right">
            <p class="adminlabel">

<?php 
   echo $module_text['region'];
   echo "&nbsp;&nbsp;\n";
?>

            </p>
         </td>
         <td align="left">
            <select class="adminlist" name="movie_region">

<?php
   require("modules/movies/lang/$lang.lists/regions.php");
   while (list ($key, $val) = each($regions_list)) {
      echo "<option value=\"$key\">$val</option>\n";
   };
?>

            </select>
         </td>
      </tr>
      <tr>
         <td align="right" valign="top">
            <p class="adminlabel">

<?php 
   echo $module_text['genre'];
   echo "&nbsp;&nbsp;\n";
?>

            </p>
         </td>

         <td align="left">
            <table>
               <tr>

<?php
   // This needlessly complex code is to display all the genres
   // in the genres list into rows of four genres with checkboxes
   require("modules/movies/lang/$lang.lists/genres.php");
   $genre_num = "1";
   while (list ($key, $val) = each($genres_list)) {
      $key = trim($key);
      $val = trim($val);
      if (ereg($key, $genre)) {
         echo "\n<td><p class=\"admintext\"><input class=\"admintext\"";
         echo "type=\"checkbox\" name=\"genre" . $genre_num . "\"";
         echo "value=\"$key\" checked>&nbsp;$val&nbsp;&nbsp&nbsp;</p></td>";
      } else {
         echo "\n<td><p class=\"admintext\"><input class=\"admintext\"";
         echo "type=\"checkbox\" name=\"genre" . $genre_num . "\"";
         echo "value=\"$key\">&nbsp;$val&nbsp&nbsp;&nbsp;</p></td>";
      };
      // Create a new line after four genres
      if (!ereg('\.', ($genre_num / 4))) {
         echo "</tr><tr>";
      };
      $genre_num ++;
   };
?>

               </tr>
            </table>
         </td>
      </tr>
      <tr>
         <td align="right">
            <p class="adminlabel">

<?php 
   echo $module_text['year'];
   echo "&nbsp;&nbsp;\n";
?>

            </p>
         </td>
         <td align="left">
            <select class="adminlist" name="year_released">

<?php
   $year = date("Y");
   while ($year != '1920') {
      if ($year == $imdb_year) {
         echo "<option selected>$year</option>";
         $imdb_update="true";
      } else {
         echo "<option>$year</option>";
      };
      $year--;
   };                         
?>

            </select>

<?php
   
   if ($imdb_update == "true") {
      $imdb_update = "";
      echo "*";
   }
?>

         </td>
      </tr>
      <tr>
         <td align='right'>
            <p class='adminlabel'>

<?php
   echo $module_text['runningtime'], "&nbsp;&nbsp;\n";
?>

            </p>
         </td>
         <td align="left">
            <input class="admintext" type="text" name="running_time" 
               size="3" maxlength="3" value="<?php echo $runtime ?>">
               &nbsp;

<?php 
   echo $module_text['minutes'];
   
   if (! is_null($runtime)) {
      echo "*";
   }
?>

         </td>
      </tr>
      <tr>
         <td align="right">
            <p class="adminlabel">

<?php 
   echo $module_text['actors'];
   echo "&nbsp;&nbsp;\n";
?>

            </p>
         </td>
         <td align="left">
            <input class="admintext" type="text" name="starring_actors" 
               size="50" maxlength="70" value="<?php echo $actors ?>">

<?php
   if (! is_null($actors)) {
      echo "*";
   };
?>

         </td>
      </tr>
      <tr>
         <td align="right" valign="top">
            <p class="adminlabel">

<?php 
   echo $module_text['synopsis'];
   echo "&nbsp;&nbsp;\n";
?>

            </p>
         </td>
         <td align="left" valign="top">
            <textarea class="admintext" name="movie_synopsis" cols="50" 
               rows="10"><?php echo trim($plot) ?></textarea>

<?php 
   if (! is_null($plot)) {
      echo "*";
   };
?>

         </td>

<?php
   if (! is_null($cover_art)) {
      echo "<td align=\"left\">";
      echo "<img src=$cover_art />";
      echo "</td>";
   };
?>

      </tr>
      <tr>
         <td align="right" valign="top">
            <p class="adminlabel">

<?php 
   echo $module_text['coverart'];
   echo "&nbsp;&nbsp;\n";
?>

            </p>
         </td>
         <td align="left">
            <input type="hidden" name="MAX_FILE_SIZE" value="50000">
            <input class="admintext" type="file" size="35" name="userfile" 
               <?php  if (! is_null($cover_art)) { echo "DISABLED=\"1\"";};?>>
         </td>
      </tr>
</table>

<br/>

<table class="admin" cellpadding="5">
      <tr>
         <td align="right">
            <input type="hidden" name="imdb_url" 
               value="<?php echo $imdb_url ?>">
            <input class="adminbutton" type="button" 
               value="<?php echo $module_text['savedetails'];?>" 
               onclick="check(form,form.elements.length)">
         </td>
         
   </form>

         <td align="left">
            <form action="index.php" method="get">
               <input class="adminbutton" type="submit" 
                  value="<?php echo $module_text['cancel'];?>">
            </form>
         </td>
         <td>
            <form action="" method="get" 
               onSubmit="window.open('modules/movies/help.php?page=addmovie','Help', 'width=450,height=350,toobar=0,scrollbars=1,location=0,statusbar=0,menubar=0,resizable=1'); return false">
               <input class="adminbutton" type="submit" 
                  value="<?php echo $module_text['showhelp'];?>">
            </form>
         </td>
      </tr>
   </table>

<?php
}; // End of security check 
?>
