##############################################################################
#
# Widget to add new items <Peter.Bienstman@ugent.be>
# Duplicate check by Jarno Elonen <elonen@iki.fi>
#
##############################################################################

from qt import *

from memaid_core import *
from add_items_frm import *
from edit_item_dlg import *
from font_util import *


##############################################################################
#
# AddItemsDlg
#
##############################################################################

class AddItemsDlg(AddItemsFrm):

    ##########################################################################
    #
    # __init__
    #
    ##########################################################################

    def __init__(self, parent = None, name = None, modal = 0, fl = 0):
        
        AddItemsFrm.__init__(self,parent,name,modal,fl)
        
        self.categories.insertItem("<default>")
        for cat in get_categories():
            if cat.name != "<default>":
                self.categories.insertItem(cat.name)

        self.connect(self.grades,SIGNAL("clicked(int)"),
                     self.new_item)
        
        if get_config("font") != None:
            font = listToFont(get_config("font"))
            self.question.setFont(font)
            self.answer.setFont(font)
            self.categories.setFont(font)
            
        self.question.setTabChangesFocus(1)
        self.answer.setTabChangesFocus(1)



    ##########################################################################
    #
    # duplicate_checked_add
    #
    ##########################################################################

    def duplicate_checked_add(self, grade, q, a, cat_name):

        if get_config("check_duplicates") == True:

            # Find duplicate questions and refuse to add if
            # duplicate answers are found as well.
            
            separate_cats = get_config("allow_duplicates_in_diff_cat")
            
            duplicates = []
            strictly_identical_found = 0
            
            for item in get_items():
                if item.q == q:
                    if item.a == a:
                        item.gr = min(item.gr, grade)
                        strictly_identical_found += 1
                    elif (not separate_cats) or (item.cat.name == cat_name):
                        duplicates.append(item)

            if strictly_identical_found > 0:
                
                QMessageBox.information(None,
                    self.trUtf8("PyQt MemAid"),
                    unicode(self.trUtf8('Total %d identical Q/A pair(s) '+
                                        'already exist.\nGrade updated but '+
                                        'duplicate not added.'))
                                        % (strictly_identical_found),
                    self.trUtf8("&Ok"))
                
                return True

            new_item = None

            # Make a list of already existing answers for this question and
            # ask the user if she wants to merge the items.
            
            if len(duplicates) > 0:
                
                answers = ''
                
                for i in duplicates:
                    answers += '<br>"' + i.a + '"'
                    
                if separate_cats:
                    msg = unicode(self.trUtf8('<b>There are %d different '+
                                              'answers in category "%s" for'+
                                              ' question</b> "%s"<br><b>'+
                                              'answers</b>:%s')) \
                                       % (len(duplicates),cat_name,q,answers)
                else:
                    msg = unicode(self.trUtf8('<b>There are %d different '+
                                              'answers for question</b> '+
                                              '"%s"<br><b>answers</b>:%s')) \
                                              % (len(duplicates), q, answers)
                    
                status = QMessageBox.question(None,
                      self.trUtf8("PyQt MemAid"), msg,
                      self.trUtf8("&Merge and edit"), self.trUtf8("&Ignore"),
                      self.trUtf8("&Cancel"), 0, -1)
                
                if status == 2: # Cancel.
                    return False
                
                if status == 0: # Merge.
                    
                    new_item = add_new_item(grade, q, a, cat_name)
                    
                    if cat_name not in get_category_names():
                        self.categories.insertItem(cat_name)
                        
                    for i in duplicates:
                        new_item.gr = min(new_item.gr, i.gr)
                        new_item.a += ' / ' + i.a
                        delete_item(i)
                        
                    dlg = EditItemDlg(new_item, self, "Edit merged item", 0)
                    dlg.exec_loop()
                    return True

        add_new_item(grade, q, a, cat_name)
        
        if cat_name not in get_category_names():
            self.categories.insertItem(cat_name)
            
        return True



    ##########################################################################
    #
    # new_item
    #
    ##########################################################################

    def new_item(self, grade):

        q = unicode(self.question.text())
        a = unicode(self.answer.text())
        cat_name = unicode(self.categories.currentText())

        if q == "" or a == "":
            return

        orig_cancelled = not self.duplicate_checked_add(grade, q, a, cat_name)
        rev_cancelled = False
        if (not orig_cancelled) and self.addViceVersa.isOn():
            rev_cancelled = not self.duplicate_checked_add(grade,a,q,cat_name)

        if self.addViceVersa.isOn() and rev_cancelled and not orig_cancelled:
            
            # Swap question and answer.
            
            self.question.setText(a)
            self.answer.setText(q)
            self.addViceVersa.setChecked(False)
            
        elif not orig_cancelled:
            
            # Clear the form to make room for new question.
            
            self.question.setText("")
            self.answer.setText("")
            
        self.question.setFocus()
