
'\"
'\" Generated from file 'fifo.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 1996-2003 Andreas Kupries <andreas_kupries@users.sourceforge.net>
'\"
'\" -*- tcl -*- doctools
.so man.macros
.TH "fifo" n 2.1  "Memory channels"
.BS
.SH "NAME"
fifo \- Create and manipulate u-turn fifo channels
.SH "SYNOPSIS"
package require \fBTcl \fR
.sp
package require \fBmemchan \fR
.sp
\fBfifo\fR \fR
.sp
.BE
.SH "DESCRIPTION"
.TP
\fBfifo\fR \fR
creates a stream-oriented in-memory channel and returns its
handle. There is no restriction on the ultimate size of the channel,
it will always grow as much as is necessary to accomodate the data
written into it.
.sp
In contrast to the channels generated by \fBmemchan\fR a channel
created here effectively represents an U-turn. All data written into
it can be read out, but only in the same order. This also means that a
fifo channel is not seekable.
.sp
The channels created here can be transfered between interpreters in
the same thread and between threads, but only as a whole. It is not
possible to use them to create a bi- or unidirectional connection
between two interpreters.
.PP
Memory channels created by \fBfifo\fR provide two read-only options
which can be queried via the standard \fBfconfigure\fR command. These
are
.TP
-length
The value of this option is the number of bytes currently
stored in the queried memory channel.
.TP
-allocated
The value of this option is the number of bytes currently
allocated by the queried memory channel. This number is at
least as big as the value of \fI-length\fR.
.PP
As the channels generated by \fBfifo\fR grow as necessary they are
always writable. This means that a writable \fBfileevent\fR-handler
will fire continuously.
.PP
The channels are also readable if they contain more than zero
bytes. Under this conditions a readable \fBfileevent\fR-handler will
fire continuously.
.SH "NOTES"
.PP
One possible application of memory channels created by \fBmemchan\fR
or \fBfifo\fR is as temporay storage device to collect data coming in
over a pipe or a socket. If part of the processing of the incoming
data is to read and process header bytes or similar fifo are easier to
use as they do not require seeking back and forth to switch between
the assimilation of headers at the beginning and writing new data at
the end.
.SH "SEE ALSO"
memchan, fifo2, null
.SH "KEYWORDS"
fifo, stream, memchan, in-memory channel, channel, i/o
.SH "COPYRIGHT"
.nf
Copyright (c) 1996-2003 Andreas Kupries <andreas_kupries@users.sourceforge.net>
.fi
