//  $Id: mmdb_sbase.h,v 1.7 2004/03/26 15:00:58 keb Exp $
//  =================================================================
//
//   CCP4 Coordinate Library: support of coordinate-related
//   functionality in protein crystallography applications.
//
//   Copyright (C) Eugene Krissinel 2004.
//
//   This library is free software and is distributed under the terms
//   and conditions of the CCP4 licence agreement as `Part 0' (Annex 2)
//   software, which is version 2.1 of the GNU Lesser General Public
//   Licence (LGPL) with the following additional clause:
//
//      `You may also combine or link a "work that uses the Library"
//      to produce a work containing portions of the Library, and
//      distribute that work under terms of your choice, provided that
//      you give prominent notice with each copy of the work that the
//      specified version of the Library is used in it, and that you
//      include or provide public access to the complete corresponding
//      machine-readable source code for the Library including whatever
//      changes were used in the work. (i.e. If you make changes to the
//      Library you must distribute those, but you do not need to
//      distribute source or object code to those portions of the work
//      not covered by this licence.)'
//
//   Note that this clause grants an additional right and does not
//   impose any additional restriction, and so does not affect
//   compatibility with the GNU General Public Licence (GPL). If you
//   wish to negotiate other terms, please contact the maintainer.
//
//   You can redistribute it and/or modify the library under the terms
//   of the GNU Lesser General Public License as published by the Free
//   Software Foundation; either version 2.1 of the License, or (at
//   your option) any later version.
//
//   This library is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Lesser General Public License for more details.
//
//   You should have received a copy of the CCP4 licence and/or GNU
//   Lesser General Public License along with this library; if not,
//   write to the CCP4 Secretary, Daresbury Laboratory, Warrington
//   WA4 4AD, UK. The GNU Lesser General Public can also be obtained
//   by writing to the Free Software Foundation, Inc., 59 Temple Place,
//   Suite 330, Boston, MA 02111-1307 USA
//
//  =================================================================
//
//    21.02.06   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :  mmdb_sbase  <implementation>
//       ~~~~~~~~~
//  **** Classes :  CSBase       ( structure base manager       )
//       ~~~~~~~~~  CSBAtom      ( SB atom class                )
//                  CSBBond      ( SB bond class                )
//                  CSBStructure ( SB structure (monomer) class )
//                  CSBIndex     ( SB index class               )
//
//    E. Krissinel 2001-2006
//
//  =================================================================
//

#ifndef  __MMDB_SBase__
#define  __MMDB_SBase__

#ifndef  __MMDB_Manager__
#include "mmdb_manager.h"
#endif

#ifndef  __MMDB_SBase0__
#include "mmdb_sbase0.h"
#endif



//  ===========================  CSBase  ============================

DefineStructure(SAtomPair)

struct SAtomPair  {
  PCAtom a1,a2;
};


DefineClass(CSBase)

class CSBase : public CSBase0  {

  public :

    CSBase ();
    ~CSBase();

    //   CalcHBonds(..) calculates hydrogen bonds and salt bridges
    // between atoms of residues given in Res1[0..nres1-1] and
    // Res2[0..nres2-1]. H-bonds are returned in HBond[0..nHBonds-1]
    // and salt bridges are returned in SBridge[0..nSBridges-1].
    //
    //   On input:
    //     Res1, Res2         must belong to the same MMDB
    //     HBond, SBridge     should be set NULL, otherwise the
    //                        function attempts to deallocate them
    //     nHBonds, nSBridges ignored
    //     structFile         may be a pointer to open SBase stucture
    //                        file in order to save on file open
    //                        operation. If structFile is set NULL,
    //                        the function will open the SBase
    //                        structure file by itself
    //     altLoc             specifies the alternative location for
    //                        donors and acceptors.
    //                          altLoc==NULL  the highest occupancy
    //                                        atoms are taken. If all
    //                                        occupancies are equal
    //                                        equal then atom with
    //                                        first altLoc taken
    //                          altLoc!=NULL  atoms with given altLoc
    //                                        are taken. If such
    //                                        altLoc is not found,
    //                                        the function acts as
    //                                        if NULL value for altLoc
    //                                        were given.
    //     ignoreNegSigOcc    if it is set True, then the function
    //                        ignores atoms with negative occupancy
    //                        standard deviation. Such atoms may be
    //                        hydrogens added by
    //                        CSBase0::AddHydrogen(..) function, in
    //                        general any atoms added by
    //                        CSBAtom::MakeCAtom(..) function. Such
    //                        added hydrogens are note guaranteed to
    //                        be in correct place, therefore the
    //                        function may mistake on some hydrogen
    //                        bonds if they are not neglected.
    //
    //   On output:
    //     Allocated arrays HBond[0..nHBonds-1] and
    //     SBridge[0..nSBridges-1]. If no bonds/bridges were found,
    //     the corresponding array is not allocated and set NULL.
    //     Application is responsible for deallocation of the arrays,
    //     when not needed, using statements
    //       if (HBond)    delete[] HBond;
    //       if (SBridge)  delete[] SBridge;
    //     HBond[i].a1, SBridge[i].a1 always refer atom from Res1[],
    //     and HBond[i].a2, SBridge[i].a2 always refer atom from
    //     Res2[].
    //
    int  CalcHBonds ( PPCResidue Res1, int nres1,
                      PPCResidue Res2, int nres2,
                      RPSAtomPair   HBond, int & nHBonds,
                      RPSAtomPair SBridge, int & nSBridges,
                      PCFile structFile=NULL, pstr altLoc=NULL,
                      Boolean ignoreNegSigOcc=False );

  protected :
    // Geometry parameters for H-bond calculations
    realtype minDAdist,maxSBdist,maxDAdist,maxHAdist2;
    realtype maxDHAcos,maxHAAcos,maxDAAcos,maxDDAcos;

    void InitSBase ();
    void FreeMemory();

};

#endif
