//  $Id: mmdb_symop.h,v 1.8 2004/03/15 12:46:32 keb Exp $
//  =================================================================
//
//   CCP4 Coordinate Library: support of coordinate-related
//   functionality in protein crystallography applications.
//
//   Copyright (C) Eugene Krissinel 2004.
//
//   This library is free software and is distributed under the terms
//   and conditions of the CCP4 licence agreement as `Part 0' (Annex 2)
//   software, which is version 2.1 of the GNU Lesser General Public
//   Licence (LGPL) with the following additional clause:
//
//      `You may also combine or link a "work that uses the Library"
//      to produce a work containing portions of the Library, and
//      distribute that work under terms of your choice, provided that
//      you give prominent notice with each copy of the work that the
//      specified version of the Library is used in it, and that you
//      include or provide public access to the complete corresponding
//      machine-readable source code for the Library including whatever
//      changes were used in the work. (i.e. If you make changes to the
//      Library you must distribute those, but you do not need to
//      distribute source or object code to those portions of the work
//      not covered by this licence.)'
//
//   Note that this clause grants an additional right and does not
//   impose any additional restriction, and so does not affect
//   compatibility with the GNU General Public Licence (GPL). If you
//   wish to negotiate other terms, please contact the maintainer.
//
//   You can redistribute it and/or modify the library under the terms
//   of the GNU Lesser General Public License as published by the Free
//   Software Foundation; either version 2.1 of the License, or (at
//   your option) any later version.
//
//   This library is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Lesser General Public License for more details.
//
//   You should have received a copy of the CCP4 licence and/or GNU
//   Lesser General Public License along with this library; if not,
//   write to the CCP4 Secretary, Daresbury Laboratory, Warrington
//   WA4 4AD, UK. The GNU Lesser General Public can also be obtained
//   by writing to the Free Software Foundation, Inc., 59 Temple Place,
//   Suite 330, Boston, MA 02111-1307 USA
//
//  =================================================================
//
//    16.02.04   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :   MMDB_SymOp <interface>
//       ~~~~~~~~~
//  **** Project :   MacroMolecular Data Base (MMDB)
//       ~~~~~~~~~
//
//  **** Classes :   CSymOp  ( symmetry operators )
//       ~~~~~~~~~   CSymOps ( container of symmetry operators )
//
//  E. Krissinel 2000-2003
//
//  =================================================================
//

#ifndef __MMDB_SymOp__
#define __MMDB_SymOp__


#ifndef __Stream__
#include "stream_.h"
#endif

#ifndef __MMDB_Defs__
#include "mmdb_defs.h"
#endif



//  ====================  CSymOp  ========================

DefineClass(CSymOp)
DefineStreamFunctions(CSymOp)

class CSymOp : public CStream  {

  public :

    CSymOp ();
    CSymOp ( RPCStream Object );
    ~CSymOp();

    int     SetSymOp  ( const pstr XYZOperation );
    pstr    GetSymOp  ();

    void    Transform ( realtype & x, realtype & y, realtype & z );

    void    GetTMatrix ( mat44 & TMatrix );  // copies T to TMatrix
    void    SetTMatrix ( mat44 & TMatrix );  // copies TMatrix to T

    Boolean CompileOpTitle ( pstr S );  // makes XYZOp from matrix T
    Boolean CompileOpTitle ( pstr S, mat44 symMat, Boolean compare );
    void    Print          ();          // prints operation and matrix

    void Copy  ( PCSymOp SymOp );

    void write ( RCFile f );
    void read  ( RCFile f );

  protected :

    pstr  XYZOp;
    mat44 T;

    void InitSymOp    ();
    void FreeMemory   ();
    int  GetOperation ( int n );

};


//  ====================  CSymOps  ========================

#define SYMOP_Ok                   0
#define SYMOP_NoLibFile           -1
#define SYMOP_UnknownSpaceGroup   -2
#define SYMOP_NoSymOps            -3
#define SYMOP_WrongSyntax         -4
#define SYMOP_NotAnOperation      -5
#define SYMOP_ZeroDenominator     -6


DefineClass(CSymOps)
DefineStreamFunctions(CSymOps)

class CSymOps : public CStream  {

  public :

    CSymOps ();
    CSymOps ( RPCStream Object );
    ~CSymOps();

    virtual void FreeMemory();

    int  SetGroupSymopLib ( const pstr SpaceGroup,
                            const pstr symop_lib=NULL );
      // Space Group is taken from symop.lib. Return Code:
      // SYMOP_Ok <=> success

    int  SetGroup ( const pstr SpaceGroup,
                    const pstr syminfo_lib=NULL );
      // Space Group is taken from syminfo.lib. Return Code:
      // SYMOP_Ok <=> success

    void Reset           ();           // removes all symmetry operations
    virtual int AddSymOp ( const pstr XYZOperation ); // adds a symmetry
                                                      // operation
    void PutGroupName    ( const pstr SpGroupName  );

    //  GetNofSymOps()  returns Nops -- the number of symmetry operations
    int  GetNofSymOps ();
    pstr GetSymOp     ( int Nop );

    //  Transform(..) transforms the coordinates according to the
    // symmetry operation Nop. The return code is non-zero if
    // Nop is a wrong operation number (must range from 0 to Nops-1).
    int  Transform ( realtype & x, realtype & y, realtype & z, int Nop );

    //  GetTMatrix(..) returns the coordinate transformation matrix
    // for the symmetry operation Nop. The return code is non-zero if
    // Nop is a wrong operation number (must range from 0 to Nops-1).
    int  GetTMatrix ( mat44 & TMatrix, int Nop );

    void Print ();

    virtual void Copy ( PCSymOps SymOps );

    void write ( RCFile f );
    void read  ( RCFile f );

  protected :

    pstr     SpGroup;
    int      Nops;
    PPCSymOp SymOp;

    void InitSymOps();

};


// extern void TestSymOps();

#endif

