//  $Id: mmdb_uddata.h,v 1.4 2004/01/28 17:22:33 keb Exp $
//  =================================================================
//
//   CCP4 Coordinate Library: support of coordinate-related
//   functionality in protein crystallography applications.
//
//   Copyright (C) Eugene Krissinel 2004.
//
//   This library is free software and is distributed under the terms
//   and conditions of the CCP4 licence agreement as `Part 0' (Annex 2)
//   software, which is version 2.1 of the GNU Lesser General Public
//   Licence (LGPL) with the following additional clause:
//
//      `You may also combine or link a "work that uses the Library"
//      to produce a work containing portions of the Library, and
//      distribute that work under terms of your choice, provided that
//      you give prominent notice with each copy of the work that the
//      specified version of the Library is used in it, and that you
//      include or provide public access to the complete corresponding
//      machine-readable source code for the Library including whatever
//      changes were used in the work. (i.e. If you make changes to the
//      Library you must distribute those, but you do not need to
//      distribute source or object code to those portions of the work
//      not covered by this licence.)'
//
//   Note that this clause grants an additional right and does not
//   impose any additional restriction, and so does not affect
//   compatibility with the GNU General Public Licence (GPL). If you
//   wish to negotiate other terms, please contact the maintainer.
//
//   You can redistribute it and/or modify the library under the terms
//   of the GNU Lesser General Public License as published by the Free
//   Software Foundation; either version 2.1 of the License, or (at
//   your option) any later version.
//
//   This library is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Lesser General Public License for more details.
//
//   You should have received a copy of the CCP4 licence and/or GNU
//   Lesser General Public License along with this library; if not,
//   write to the CCP4 Secretary, Daresbury Laboratory, Warrington
//   WA4 4AD, UK. The GNU Lesser General Public can also be obtained
//   by writing to the Free Software Foundation, Inc., 59 Temple Place,
//   Suite 330, Boston, MA 02111-1307 USA
//
//  =================================================================
//
//    17.11.00   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :   MMDBF_UDData <interface>
//       ~~~~~~~~~
//  **** Project :   MacroMolecular Data Base (MMDB)
//       ~~~~~~~~~
//
//  **** Classes :   CUDData ( user-defined data )
//       ~~~~~~~~~
//
//  E. Krissinel 2000-2001
//
//  =================================================================
//

#ifndef __MMDB_UDData__
#define __MMDB_UDData__


#ifndef __MMDB_Mask__
#include "mmdb_mask.h"
#endif



//  ========================  CUDRegister  ==========================

#define UDR_ATOM       0
#define UDR_RESIDUE    1
#define UDR_CHAIN      2
#define UDR_MODEL      3
#define UDR_HIERARCHY  4

#define UDRF_ATOM       0x01000000
#define UDRF_RESIDUE    0x02000000
#define UDRF_CHAIN      0x04000000
#define UDRF_MODEL      0x08000000
#define UDRF_HIERARCHY  0x10000000
#define UDRF_MASK       0x00FFFFFF


DefineClass(CUDRegister)
DefineStreamFunctions(CUDRegister)

class CUDRegister : public CStream  {

  public :

    CUDRegister ();
    CUDRegister ( RPCStream Object );
    ~CUDRegister();

    int RegisterUDInteger ( int udr_type, const pstr UDDataID );
    int RegisterUDReal    ( int udr_type, const pstr UDDataID );
    int RegisterUDString  ( int udr_type, const pstr UDDataID );
    int GetUDDHandle      ( int udr_type, const pstr UDDataID );

    void write ( RCFile f );
    void read  ( RCFile f );

  protected :
    int      nIUDR[5],nRUDR[5],nSUDR[5];
    psvector IUDRegister[5];
    psvector RUDRegister[5];
    psvector SUDRegister[5];

    void  InitUDRegister ();
    void  FreeUDRegister ();
    int   RegisterUDData ( psvector & UDRegister,
                           int      & nUDR,
                           const pstr UDDataID );

};


//  ==========================  CUDData  ============================


#define UDDATA_Ok             0
#define UDDATA_WrongHandle   -1
#define UDDATA_WrongUDRType  -2
#define UDDATA_NoData        -3

DefineClass(CUDData)
DefineStreamFunctions(CUDData)

class CUDData : public CMask  {

  friend class CMMDBSelManager;

  public :

    CUDData ();
    CUDData ( RPCStream Object );
    ~CUDData();

  protected :
    ivector  IUData;
    rvector  RUData;
    psvector SUData;

    void  InitUDData   ();
    void  FreeUDDMemory();
    int   getNofIUData ();
    int   getNofRUData ();
    int   getNofSUData ();
    void  setNofSUData ( int newN );

    int   putUDData ( int UDDhandle, int      iudd );
    int   putUDData ( int UDDhandle, realtype rudd );
    int   putUDData ( int UDDhandle, const pstr sudd );

    int   getUDData ( int UDDhandle, int      & iudd );
    int   getUDData ( int UDDhandle, realtype & rudd );
    int   getUDData ( int UDDhandle, pstr sudd, int maxLen );
    pstr  getUDData ( int UDDhandle, int * retcode=NULL );
    int   getUDData ( int UDDhandle, pstr     & sudd );

    void  write ( RCFile f );
    void  read  ( RCFile f );

};


#endif

