//  $Id: mmdb_xml.h,v 1.4 2004/01/28 17:22:33 keb Exp $
//  =================================================================
//
//   CCP4 Coordinate Library: support of coordinate-related
//   functionality in protein crystallography applications.
//
//   Copyright (C) Eugene Krissinel 2004.
//
//   This library is free software and is distributed under the terms
//   and conditions of the CCP4 licence agreement as `Part 0' (Annex 2)
//   software, which is version 2.1 of the GNU Lesser General Public
//   Licence (LGPL) with the following additional clause:
//
//      `You may also combine or link a "work that uses the Library"
//      to produce a work containing portions of the Library, and
//      distribute that work under terms of your choice, provided that
//      you give prominent notice with each copy of the work that the
//      specified version of the Library is used in it, and that you
//      include or provide public access to the complete corresponding
//      machine-readable source code for the Library including whatever
//      changes were used in the work. (i.e. If you make changes to the
//      Library you must distribute those, but you do not need to
//      distribute source or object code to those portions of the work
//      not covered by this licence.)'
//
//   Note that this clause grants an additional right and does not
//   impose any additional restriction, and so does not affect
//   compatibility with the GNU General Public Licence (GPL). If you
//   wish to negotiate other terms, please contact the maintainer.
//
//   You can redistribute it and/or modify the library under the terms
//   of the GNU Lesser General Public License as published by the Free
//   Software Foundation; either version 2.1 of the License, or (at
//   your option) any later version.
//
//   This library is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Lesser General Public License for more details.
//
//   You should have received a copy of the CCP4 licence and/or GNU
//   Lesser General Public License along with this library; if not,
//   write to the CCP4 Secretary, Daresbury Laboratory, Warrington
//   WA4 4AD, UK. The GNU Lesser General Public can also be obtained
//   by writing to the Free Software Foundation, Inc., 59 Temple Place,
//   Suite 330, Boston, MA 02111-1307 USA
//
//  =================================================================
//
//    30.05.03   <--  Date of Last Modification.
//                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//  -----------------------------------------------------------------
//
//  **** Module  :  MMDB_XML <interface>
//       ~~~~~~~~~
//  **** Project :  MacroMolecular Data Base (MMDB)
//       ~~~~~~~~~
//  **** Classes :  CXMLObject
//       ~~~~~~~~~
//
//  E. Krissinel 2002-2003
//
//  =================================================================
//

#ifndef __MMDB_XML__
#define __MMDB_XML__


#ifndef __MMDB_MMCIF__
#include "mmdb_mmcif.h"
#endif



//  ======================  CXMLObject  ==========================

#define XMLR_Ok           0
#define XMLR_NoFile       1
#define XMLR_NoTag        2
#define XMLR_BrokenTag    3
#define XMLR_UnclosedTag  4

DefineClass(CXMLObject)
DefineStreamFunctions(CXMLObject)

class CXMLObject : public CStream  {

  public :

    CXMLObject ();
    CXMLObject ( const pstr Tag );
    CXMLObject ( const pstr Tag, const pstr Data );
    CXMLObject ( const pstr Tag, realtype V, int length=11 );
    CXMLObject ( const pstr Tag, int     iV, int length=0  );
    CXMLObject ( const pstr Tag, Boolean bV );
    CXMLObject ( const pstr Tag, PCXMLObject XMLObject );
    CXMLObject ( RPCStream Object );
    ~CXMLObject();

    void  SetTag  ( const pstr Tag  );
    void  SetData ( const pstr Data );
    void  AddData ( const pstr Data );
    void  SetData ( realtype V, int length=11 );
    void  SetData ( int     iV, int length=0  );
    void  SetData ( Boolean bV );

    int   AddMMCIFCategory ( PCMMCIFCategory mmCIFCat    );
    int   AddMMCIFStruct   ( PCMMCIFStruct   mmCIFStruct );
    int   AddMMCIFLoop     ( PCMMCIFLoop     mmCIFLoop   );
    int   AddMMCIFData     ( PCMMCIFData     mmCIFData   );

    pstr  GetTag  () { return objTag; }

    //   Here and below the functions allow for "tag1>tag2>tag3>..."
    // as a composite multi-level tag, e.g. the above may stand for
    // <tag1><tag2><tag3>data</tag3></tag2></tag1>. NULL tag
    // corresponds to "this" object.
    //   objNo counts same-tag objects of the *highest* level used
    // (e.g. level tag3 for composite tag  tag1>tag2>tag3 ).
    //   GetData ( pstr& ... ) only copies a pointer to data.
    pstr  GetData ( const pstr Tag=NULL, int objNo=1 );
    int   GetData ( pstr   & Data, const pstr Tag=NULL, int objNo=1 );
    int   GetData ( realtype &  V, const pstr Tag=NULL, int objNo=1 );
    int   GetData ( int      & iV, const pstr Tag=NULL, int objNo=1 );
    int   GetData ( Boolean  & bV, const pstr Tag=NULL, int objNo=1 );

    PCXMLObject GetObject ( const pstr Tag, int objNo=1 );

    void  AddObject   ( PCXMLObject XMLObject, int lenInc=10 );
    int   WriteObject ( const pstr FName, int pos=0, int ident=2   );
    void  WriteObject ( RCFile f, int pos=0, int ident=2   );
    int   ReadObject  ( const pstr FName );
    int   ReadObject  ( RCFile f, pstr S, int & pos, int slen );

    virtual void Copy ( PCXMLObject XMLObject );

    void  write ( RCFile f );
    void  read  ( RCFile f );

  protected:
    pstr         objTag;
    pstr         objData;
    int          nObjects,nAlloc;
    PPCXMLObject object;

    void         InitXMLObject();
    virtual void FreeMemory   ();

};


extern  PCXMLObject mmCIF2XML ( PCMMCIFData mmCIFData, int * rc=NULL );
extern  PCXMLObject mmCIF2XML ( const pstr XMLName, PCMMCIFFile mmCIFFile,
                                                       int * rc=NULL );

#endif


