#####################################################################
# text.tcl - text only interface
#
# Copyright (C) 1997-2002 Mark Patton
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#####################################################################

proc mmucl::event {ses event args} {
    variable Mmucl
    
    switch -exact $event {
	attempt {
	} connect {
	} disconnect {
	} timeout {
	} ses_new {
	} ses_switch {
	} ses_close {
	} default {
	    error "event $event not understood"
	}
    }
}

proc mmucl::stdin_parse {} {
    variable Mmucl

    if {[gets stdin line] == -1} {
	MCexit $Mmucl(cur)
    }

    meta_parse $line
}

proc mmucl::display {ses str} {
    variable Mmucl

    if {$ses != $Mmucl(cur)} {
	return
    }

    puts -nonewline $str
    flush stdout
}

proc mmucl::interface_init {} {
    fileevent stdin readable mmucl::stdin_parse
    
    rename interface_init ""
}
