      SUBROUTINE MN_PLH(IDA,IDB,NP,NTYPFL,NOVEFL,NDERR)
C
C     NTYPFL   +      Ordinary plot
C     NTYPFL   -      Fit plot
C     NTYPFL = 0      Draw the latest plot
C     NTYPFL = 1      Draw all the stored plots
C     NTYPFL = 2      Redraw
C     NTYPFL = 3      Hardcopy
C
C     NOVEFL = 1      Draw an ordinary plot
C     NOVEFL = 2 or 3 Overlay another picture
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mnfit.inc"
#include "mninf.inc"
#include "mnhpj.inc"
#include "mncmd.inc"
#include "mngrn.inc"
#include "mnlun.inc"
C
      LOGICAL QFIT
C
      DATA NCALL/0/
C
      QFIT = .FALSE.
      NH = 0
C
C     FIT PLOT
C     FIRST PLOT IN A DISPLAY IS ALWAYS THE PLOT WE ARE FITTING
C
      IF(NTYPFL.LT.0 .AND. NCLRU.EQ.1) THEN
          QFIT = .TRUE.
          CALL MN_FGT(IDA,IDB,NH)
          IF(NH.GT.0) GOTO 1000
      ENDIF
C
C     ALL OTHERS
C
      QFIT = .FALSE.
      CALL MN_HGT(IDA,IDB,NH)
      IF(NH.LE.0) THEN
          IERR = 3
          GOTO 9100
      ENDIF
C
 1000 CONTINUE
      NCALL = NCALL + 1
C
C     DECIDE WHETHER TO ASK FOR A <CR>
C
      IF(NCALL.GT.1 .AND. NCLRU.EQ.1 .AND. IABS(NTYPFL).NE.3) THEN
          IF((.NOT.QRFILE .AND. NP.NE.1) .OR.
     1       (QRFILE .AND.
     1        ((QSAMDV .AND. QASWCH) .OR. (.NOT.QSAMDV))) .OR.
     1       (QSAMDV .AND. NTYPFL.EQ.-1 .AND. NP.EQ.1)) THEN
              IF(QAWAIT) THEN
                  CALL MN_CRT(0,' ',IERR)
                  IF(IERR.NE.0) NDERR = -1
                  IF(IERR.NE.0) GOTO 9000
              ENDIF
          ENDIF
      ENDIF
C
      IF(QFIT) THEN
          CALL MN_UOF(RFIT(NPTRH),ACONT)
          CALL MN_PLT(IDA,IDB,RFIT(NPTRD),NDIM,NWPPT,NPNT,NOVEFL
     1     ,TFTIT(NH),TFFIL(NH),NHDATE,NHTIME,NSDATE,NSTIME,NTMODE
     2     ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,AMEAN,ASIG,ACONT,IERR)
      ELSE
          CALL MN_UOF(RDAT(NPTRH),ACONT)
          CALL MN_PLT(IDA,IDB,RDAT(NPTRD),NDIM,NWPPT,NPNT,NOVEFL
     1     ,TDTIT(NH),TDFIL(NH),NHDATE,NHTIME,NSDATE,NSTIME,NTMODE
     2     ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,AMEAN,ASIG,ACONT,IERR)
      ENDIF
C
      IF(IERR.GT.0) GOTO 9100
C
 9000 CONTINUE
      RETURN
C
 9100 CONTINUE
C
C     WRITE OUT ERROR MESSAGE
C
      CALL MN_TOF(.FALSE.)
      IF(IERR.EQ.1) THEN
          WRITE(TXTERR,91100) IDA,IDB
91100     FORMAT('Histogram',I7,I4,'  Error in plot limits.')
          CALL M_EMSG('MN_PLH',TXTERR)
          CALL M_EMSG('MN_PLH'
     +     ,'Probably the histogram has no entries or')
          CALL M_EMSG('MN_PLH','you have' //
     +     ' incorrectly specified the limits for a log scale.')
C          CALL MN_ERR('MN_PLH','To display this histogram you must' //
C     +     ' set the limits manually')
          ierr = 0
          GOTO 9000
      ELSEIF(IERR.EQ.2) THEN
          WRITE(TXTERR,91200) IDA,IDB
91200     FORMAT('Histogram',I7,I4
     1       ,'  I can only plot 1 or 2-dimensional histograms')
          CALL M_EMSG('MN_PLH',TXTERR)
          WRITE(TXTERR,'(''You asked for a'',I3,''-dimensional one'')')
     +     NDIM
          CALL MN_ERR('MN_PLH',TXTERR)
      ELSEIF(IERR.EQ.3) THEN
          WRITE(TXTERR,91300) IDA,IDB
91300     FORMAT('Histogram',I7,I4,' does not exist')
          CALL MN_ERR('MN_PLH',TXTERR)
      ELSEIF(IERR.EQ.4) THEN
          WRITE(TXTERR,91400) IDA,IDB
91400     FORMAT('Histogram',I7,I4,' is not 2-dimensional'
     +     ,' so you cannot LEGO plot it')
          CALL MN_ERR('MN_PLH',TXTERR)
      ELSEIF(IERR.EQ.6) THEN
          WRITE(TXTERR,91600)
91600     FORMAT('Log scale not allowed for x or y axis'
     +     ,' of a lego or surface plot')
          CALL MN_ERR('MN_PLH',TXTERR)
      ELSEIF(IERR.EQ.7) THEN
          WRITE(TXTERR,91700)
91700     FORMAT('Error in HIGZ IGTABL interface')
          CALL MN_ERR('MN_PLH',TXTERR)
      ENDIF
C
C     SET WINDOW NUMBER BACK IF WE HAD AN ERROR
C
      IF(QWIND .AND. NOVEFL.EQ.1 .AND.
     1   (IABS(NTYPFL).EQ.0 .OR. IABS(NTYPFL).EQ.1)) THEN
          IF(IPWNDS(1).GT.1) THEN
              IPWNDS(1) = IPWNDS(1) - 1
          ELSEIF(IPWNDS(2).GT.1) THEN
              IPWNDS(2) = IPWNDS(2) - 1
              IPWNDS(1) = IWIND(1)
          ELSE
              IPWNDS(1) = 0
              IPWNDS(2) = 0
          ENDIF
      ENDIF
C
      RETURN
      END
