      SUBROUTINE M_CCMS(IDELIM,IERR)
C
C-----------------------------------------------------------------------
C
C     Makes a COMIS file as a cut or compiles or edits and compiles
C     an existing file.
C     Makes a skeleton if necessary and compiles the function.
C
C     Called by MN_CUT
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mninf.inc"
#include "mncut.inc"
#include "mnflg.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      INTEGER IDELIM,IERR
      CHARACTER*255 TXT1
      CHARACTER*255 TFIL1,TFIL2,TFUNC
      INTEGER ida,idb,idh,nh,nh2,NCHR1,NADR,LENF,len1,len2,LENOCC,NC,i
     + ,kcmd,nnid
      integer inttyq,isltyq,icmtyq
      LOGICAL QEXIST,qcwntp,hntnew,accessf
C
      IF(COMND2.EQ.'FILE') THEN
          CALL WAITYQ('Give the filename and plot number: ')
      ELSE
          NC = 0
          CALL WAITYQ('Give cut number or filename: ')
      ENDIF
      NCHR1 = ISLTYQ(.TRUE.,IDELIM,TFIL1)
      IF(NCHR1.LE.0 .OR. IDELIM.GT.0) GOTO 9000
C
C     Give the plot number associated with the cut
C
      IF(COMND2.EQ.'FILE') THEN
          NH = 0
          IF(IDELIM.EQ.0) THEN
              CALL WAITYQ(
     +         'Give the plot number associated with the cut: ')
              CALL MN_HNO(IDA,IDB,IDELIM,NNID)
              IF(NNID.GT.0 .AND. IDA.NE.0) THEN
                  CALL MN_HGT(IDA,IDB,NH)
*
*                 Find out if it is a CWN
*
                  qcwntp = .false.
                  if(ndim.lt.0 .and. nwdat.le.0) then
                      if(qafetch) then
                          nh2 = nh
                      else
                          nh2 = -nh
                      endif
                      call m_intp(ida,idb,nh2,ierr)
                      if(ierr.ne.0) goto 9000
                      idh = ida
                      qcwntp = hntnew(idh)
                  endif
              ENDIF
          ENDIF
C
C         See if the file exists and if not write the skeleton
C
          tfil2 = tfil1(:nchr1)
          call m_pfil(0,tfil2,ierr)
          if(ierr.ne.0) goto 9000
#if ( defined(UNIX) )
          qexist = accessf(tfil2,0)
#endif
#if ( defined(VMS) )
          INQUIRE(FILE=TFIL2,EXIST=QEXIST)
#endif

          IF(.NOT.QEXIST) THEN
              CALL M_SKEL(2,LUNTMP,NH,IERR,TFIL2)
              IF(IERR.NE.0) GOTO 9000
          ENDIF
*ICB          tfil1 = tfil2
*ICB          INQUIRE(FILE=TFIL1,NAME=TFIL2)
C
C     See if the cut number was given
C
      ELSEIF(ICHAR(TFIL1(1:1)).GE.ICHAR('0') .AND.
     +       ICHAR(TFIL1(1:1)).LE.ICHAR('9')) THEN
          CALL RESTYQ
          NC = INTTYQ(.TRUE.,IDELIM)
          IF(IDELIM.LE.0 .AND. NC.GT.0 .AND. NC.LE.NCCUT) THEN
              TFIL2 = TCVAR(NC)
          ELSE
              NC = 0
          ENDIF
      ELSE
          TFIL2 = TFIL1
      ENDIF
C
C     Get the filename and check that it is a cut
C
      IF(NC.LE.0 .AND. COMND2.NE.'FILE') THEN
          call m_pfil(1,tfil2,ierr)
          if(ierr.ne.0) goto 9000
#if ( defined(UNIX) )
          qexist = accessf(tfil2,0)
#endif
#if ( defined(VMS) )
          INQUIRE(FILE=TFIL2,EXIST=QEXIST)
#endif

          IF(.NOT.QEXIST) THEN
              LENF = LENOCC(TFIL2)
              TXTERR = 'Comis file ' // TFIL2(1:LENF) //
     +         ' does not exist'
              CALL MN_ERR('M_CCMS',TXTERR)
              GOTO 9000
          ELSE
              TFIL1 = TFIL2
              CALL MN_FIL(43,LUNTMP,TFIL1,IDELIM,IERR)
              IF(IERR.NE.0) GOTO 9000
              CLOSE(UNIT=LUNTMP)
#if ( defined(VMS) )
              LEN1 = INDEX(TFIL1,';') - 1
              IF(LEN1.LE.0) LEN1 = LENOCC(TFIL1)
#endif
#if ( !defined(VMS) )
              LEN1 = LENOCC(TFIL1)
#endif

              len2 = lenocc(tfil2)
              DO 1000 I=1,NCCUT
                  IF(ICTYPE(I).EQ.4 .AND.
     +               TFIL2(1:LEN2).EQ.TCVAR(I)) THEN
                      NC = I
                      GOTO 1010
                  ENDIF
1000          CONTINUE
              TXTERR = 'File ' // TFIL2(1:LEN2) //
     +         ' is not a defined cut'
              CALL MN_ERR('M_CCMS',TXTERR)
              GOTO 9000
1010          CONTINUE
          ENDIF
*ICB          TFIL2 = TFIL1
      ENDIF
C
C     Edit the COMIS function
C
      IF(COMND2.EQ.'FILE') THEN
          CALL WAITYQ('Edit the COMIS function file [Y/N]: ')
          KCMD = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
      ELSEIF(COMND2.EQ.'EDIT') THEN
          KCMD = 1
      ELSE
          KCMD = 0
      ENDIF
      IF(MOD(KCMD,2).EQ.1) THEN
          CALL QUOTYQ(TFIL2)
          TXT1 = 'EDIT'
          CALL MN_SPW(TXT1,IDELIM)
      ENDIF
C
C     Compile the COMIS function
C
      CALL M_FCMS(0,TFIL2,TFIL1,TFUNC,NADR,IERR)
      IF(IERR.NE.0) GOTO 9000
C
C     Add the new cut. Use ICTYPE = 4 to flag it as a COMIS function
C
      IF(COMND2.EQ.'FILE') THEN
          NCCUT = NCCUT + 1
          ICTYPE(NCCUT)   = 4
*ICB          TCVAR(NCCUT)    = TFIL1
          TCVAR(NCCUT)    = TFIL2
          ICVAR(1,NCCUT)  = NADR
          call vzero_i(ICVAR(2,NCCUT),9)
          ICCOND(NCCUT)   = 0
          TCVAL(NCCUT)    = TFUNC
      ELSE
          ICVAR(1,NC)  = NADR
          call vzero_i(ICVAR(2,NC),9)
      ENDIF
C
9000  CONTINUE
      END
