      subroutine tyqcomm(text,nnchar,txtc)
*
*------------------------------------------------------------------------------
*     Look for the comment in a string
*
*     Arguments:
*     *text*     Text with string - returned is command
*     *nnchar*   Number of characters
*     *txtc      Comment text
*------------------------------------------------------------------------------
*
      implicit none
*
#include "mntyq.inc"
#include "mncmt.inc"
*
      character*(*) text,txtc
      integer nnchar
*
      character txto*255
      integer ind,i
      logical qsq,qdq,qskip
      integer lnblnk
*
*------------------------------------------------------------------------------
*
      txtc = ' '
*
*     Strip off any comments - if comment character is in quotes then
*     ignore it.
*
      IND = INDEX(TEXT(:NNCHAR),TSCOMM)
      IF(IND.EQ.1) THEN
          TXTC   = TEXT
          TEXT   = ' '
          NNCHAR = 1
*
*     Scan the string looking for continuation characters
*     and look for pairs of quotes
*
      ELSEIF(IND.GT.1) THEN
          QSQ   = .FALSE.
          QDQ   = .FALSE.
          QSKIP = .FALSE.
          DO I=1,NNCHAR
              IF(QSKIP) THEN
                  QSKIP = .FALSE.
              ELSEIF(TEXT(I:I).EQ.'''') THEN
*
*                 If inside quotes and next character is ' then skip
*
                  IF(QSQ .AND. I.LT.NNCHAR .AND.
     +             TEXT(I+1:I+1).EQ.'''') THEN
                      QSKIP = .TRUE.
                  ELSEIF(QSQ) THEN
                      QSQ = .FALSE.
                  ELSE
                      QSQ = .TRUE.
                  ENDIF
              ELSEIF(TEXT(I:I).EQ.'"') THEN
*
*                 If inside quotes and next character is " then skip
*
                  IF(QDQ .AND. I.LT.NNCHAR .AND.
     +             TEXT(I+1:I+1).EQ.'"') THEN
                      QSKIP = .TRUE.
                  ELSEIF(QDQ) THEN
                      QDQ = .FALSE.
                  ELSE
                      QDQ = .TRUE.
                  ENDIF
*
*             Comment character that is not inside quotes
*
              ELSEIF(TEXT(I:I).EQ.TSCOMM .AND.
     +         .NOT.QSQ .AND. .NOT.QDQ) THEN
                  TXTC   = TEXT(I:NNCHAR)
                  NNCHAR = I - 1
                  TXTO   = TEXT(:NNCHAR)
                  NNCHAR = LNBLNK(TXTO)
                  IF(NNCHAR.LE.0) THEN
                      TEXT = ' '
                      NNCHAR = 1
                  ELSE
                      TEXT = TXTO(:NNCHAR)
                  ENDIF
                  GOTO 2000
              ENDIF
          ENDDO
      ENDIF
 2000 continue
*
      end
