      SUBROUTINE cleo_REPLUN
C.......................................................................
C.
C. REPLUN - Report current status of LUN table
C.
C. Inputs    : None
C. Outputs   : None
C.
C. COMMON    : LUNMCI LUNMCC
C. Calls     : INILUN MESLOG MESOUT
C. Called    : ERRLUN <USER>
C.
C.......................................................................
      SAVE
C
C------------------------- Argument declarations -----------------------
C
* None
C
C------------------------- EXTERNAL declarations -----------------------
C
* None
C
C------------------------- SEQUENCE declarations -----------------------
C
C
* LUNMIN - Smallest allowed LUN number
* LUNMAX - Largest  allowed LUN number
* MAXLUN - Length of the    LUN number allocation table
*
      INTEGER    LUNMIN,     LUNMAX
      PARAMETER( LUNMIN = 1, LUNMAX = 99 )
*
      INTEGER    MAXLUN
      PARAMETER( MAXLUN = LUNMAX - LUNMIN + 1 )
*
* LISUSE - Flag for LUN is in use
* LISFRE - Flag for LUN is free
* LISLOK - Flag for LUN is locked
*
      INTEGER    LISUSE,     LISFRE,     LISLOK
      PARAMETER( LISUSE = 1, LISFRE = 0, LISLOK = -1 )
*
* LUSEER - Error, LUN in use
* LRNGER - Error, LUN number out of range
* LTABER - Error, LUN allocation table corrupted
* LFULER - Error, LUN allocation table full
* LLOKER - Error, LUN is already locked
* LFLKER - Error, LUN is locked, cannot be freed
* LINIER - Error, in initialization
* LUALER - Error, found unalloacted unit connected to file
* LNONAM - Warning, Allocator name is blank
* LDIFER - Warning, Allocator and deallocator are different
*
      INTEGER    LUSEER,     LRNGER,     LTABER,     LFULER
      PARAMETER( LUSEER = 1, LRNGER = 2, LTABER = 3, LFULER = 4 )
      INTEGER    LLOKER,     LFLKER,     LINIER,     LUALER
      PARAMETER( LLOKER = 5, LFLKER = 6, LINIER = 7, LUALER = 8 )
      INTEGER    LNONAM,     LDIFER
      PARAMETER( LNONAM = 9, LDIFER =10                         )
*
* LUNTBL - The LUN allocation table
* LUNOWN - The LUN allocation owner table
*
      INTEGER         LUNTBL
      COMMON /LUNMCI/ LUNTBL(LUNMIN:LUNMAX)
      CHARACTER*8     LUNOWN
      COMMON /LUNMCC/ LUNOWN(LUNMIN:LUNMAX)
*
* MSSUCC - Message severity is SUCCESS
* MSINFO - Message severity is INFORMATION
* MSWARN - Message severity is WARNING
* MSERRO - Message severity is ERROR
* MSFATA - Message severity is FATAL
* CHMESS - Text of current message
*
      CHARACTER*(*) MSSUCC,             MSINFO
      PARAMETER(    MSSUCC = 'SUCCESS', MSINFO = 'INFORMATION' )
      CHARACTER*(*) MSWARN,             MSERRO
      PARAMETER(    MSWARN = 'WARNING', MSERRO = 'ERROR'       )
      CHARACTER*(*) MSFATA
      PARAMETER(    MSFATA = 'FATAL'                           )
*
      CHARACTER*132   CHMESS
      COMMON /MESREP/ CHMESS
*
C
C------------------------- Local    declarations -----------------------
C
      LOGICAL LFIRST
      INTEGER I
C
C------------------------- SAVE     declarations -----------------------
C
      SAVE LFIRST
C
C------------------------- DATA  initializations -----------------------
C
      DATA LFIRST /.TRUE./
C
C---------------------- Executable code starts here --------------------
C
*
      IF( LFIRST ) THEN
         LFIRST = .FALSE.
         CALL CLEO_INILUN
      ENDIF
C
C== Loop over LUN table and report status
C
      WRITE(CHMESS,1000)
      CALL CLEO_MESLOG( 'REPLUN', 1, MSINFO )
*
      WRITE(CHMESS,1010)
      CALL CLEO_MESOUT(0,0)
      DO 10 I = LUNMIN, LUNMAX

         IF(     LUNTBL(I).EQ.LISFRE ) THEN
             WRITE(CHMESS,1020) I
         ELSEIF( LUNTBL(I).EQ.LISUSE ) THEN
             WRITE(CHMESS,1030) I, LUNOWN(I)
         ELSEIF( LUNTBL(I).EQ.LISLOK ) THEN
             WRITE(CHMESS,1040) I, LUNOWN(I)
         ELSE
             WRITE(CHMESS,1050) I
         ENDIF

         CALL CLEO_MESOUT(0,0)

10    CONTINUE
C
      RETURN
*
 1000 FORMAT(' Status of the LUN manager unit allocation table' )
 1010 FORMAT(' LUN number',15X,' Status' )
 1020 FORMAT(1X,I6,15X,'Free' )
 1030 FORMAT(1X,I6,15X,'Allocated by ', A )
 1040 FORMAT(1X,I6,15X,'Locked    by ', A )
 1050 FORMAT(1X,I6,15X,'Table entry corrupted' )
*
999   END
