///////////////////////////////////////////////////////////////////////////////
// $Id: maptoolselect.cpp,v 1.2 2004/04/04 17:07:52 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    maptoolselect.cpp
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Implementation of the selection tool class for maps
*/

// local includes
#include "mapdocument.h"
#include "maptoolselect.h"

///////////////////////////////////////////////////////////////////////////////

MapToolSelect::MapToolSelect(MapDocument* doc) : MapTool(doc)
{
}

///////////////////////////////////////////////////////////////////////////////

MapToolSelect::~MapToolSelect()
{
}

///////////////////////////////////////////////////////////////////////////////

void MapToolSelect::activate()
{
	// clear rect
	m_rect = QRect();
	m_start = QPoint();
	m_end = QPoint();
	if (m_doc != 0)
		m_doc->setSelectionArea(m_rect);
}

///////////////////////////////////////////////////////////////////////////////

bool MapToolSelect::usedMousePress(uint row, uint col, int button)
{
	if (button != Qt::LeftButton) return false;

	// sanity checks
	if (m_doc == 0) return false;
	if (static_cast<int>(row) >= m_doc->numRows() ||
	    static_cast<int>(col) >= m_doc->numCols()) return false;

	m_start = QPoint(col, row);
	m_rect = QRect(col, row, 1, 1);
	m_doc->setSelectionArea(m_rect);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool MapToolSelect::usedMouseRelease(uint row, uint col, int button)
{
	if (button == Qt::RightButton)
	{
		activate();
		return true;
	}

	if (button != Qt::LeftButton) return false;

	// sanity checks
	if (m_doc == 0) return false;
	if (static_cast<int>(row) >= m_doc->numRows() ||
	    static_cast<int>(col) >= m_doc->numCols()) return false;

	m_end = QPoint(col, row);
	m_rect = QRect(m_start, m_end).normalize();

	m_doc->setSelectionArea(m_rect);

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool MapToolSelect::usedMouseMove(uint row, uint col, int buttons)
{
	if ((buttons & Qt::LeftButton) == 0) return false;

	m_end = QPoint(col, row);
	m_rect = QRect(m_start, m_end).normalize();

	return true;
}

///////////////////////////////////////////////////////////////////////////////

bool MapToolSelect::coversTileAt(uint row, uint col) const
{
	return m_rect.contains(col, row);
}

///////////////////////////////////////////////////////////////////////////////

QRect MapToolSelect::coverArea() const
{
	return m_rect;
}

// End of file
