/* -*- mode: c; style: linux -*- */

/* VOLUME.h
 *
 * Written by Todd Brandt <todd.e.brandt@intel.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __VOLUME_H__
#define __VOLUME_H__

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/soundcard.h>
#include <alsa/asoundlib.h>
#include <gtk/gtk.h>

/* initialize the library, call this prior to use */
int init_alsa_vars();

/* returns the number of sound elements with volume and/or switch controls */
int num_sound_elements();

/* returns the number of channels for the element */
int num_channels(int e);

/* returns the name of a sound element given its index */
gchar* name_from_index(int e);

/* returns the name of a channel given its indexes */
const char* name_from_channel(int e, int channel);

/* returns the index of a sound element given its name */
int index_from_name(char *name);

/* gets the max and min volume values for a given sound element */
int get_volume_range(int e, int *min, int *max);

/* gets the volume range for the primary sound element */
int get_pse_volume_range(void);

/* gets the volume value for a given sound element & channel */
int get_volume(int e, int channel, int *val);

/* sets the volume value for a given sound element & channel */
int set_volume(int e, int channel, int val);

/* sets all volume values for a given sound element */
int set_all_volume(int e, int val);

/* gets the switch value for a given sound element & channel */
int get_switch(int e, int channel, int *val);

/* sets the switch value for a given sound element & channel */
int set_switch(int e, int channel, int val);

/* sets all switch values for a given sound element */
int set_all_switch(int e, int val);

/* sets all switch values for all sound elements */
int set_all_playback_switches_all_channels(int val);

/* gets the index of the primary sound element */
int get_primary_sound_element_index();

/* sets the index of the primary sound element */
void set_primary_sound_element_index(int e);

/* gets the supported features of the element */
int get_support(int e, int *vol, int *sw);

#endif /* __VOLUME_H__ */
