/* moblin-settings-brightness.c
 *
 * Copyright � 2007 Intel Corp
 *
 * Written by Todd Brandt <todd.e.brandt@intel.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <sys/types.h>

#include <glib/gi18n.h>
#include <gconf/gconf-client.h>
#include <moblin.h>
#include "brightness.h"
#include "moblin-settings-brightness.h"
#include "moblin-settings-daemon.h"

static BrightnessControl brightness_control = {
	NULL, NULL, NULL, 0, NULL
};

void
do_brightness_action (int type)
{
	int val, mid;

	/* if there's no connection, seeya */
	if(brightness_control.connection == NULL) return;

	get_brightness(&brightness_control);
	val = brightness_control.level;
	switch(type) {
	case BRIGHTNESS_UP:
		if(val < MAX_BRIGHTNESS_LEVEL) val++;
		break;
	case BRIGHTNESS_DOWN:
		if(val > MIN_BRIGHTNESS_LEVEL) val--;
		break;
	case BRIGHTNESS_MAXMIN:
		mid = MIN_BRIGHTNESS_LEVEL + 
			((MAX_BRIGHTNESS_LEVEL - MIN_BRIGHTNESS_LEVEL)/2);
		if(val >= mid)
			val = MIN_BRIGHTNESS_LEVEL;
		else
			val = MAX_BRIGHTNESS_LEVEL;
		break;
	default:
		return;
	}
	brightness_control.level = val;
	set_brightness(&brightness_control);
}

void
moblin_settings_brightness_init (GConfClient *client)
{
	if(brightness_control.connection == NULL)
	{
		brightness_dbus_connect(&brightness_control);
	}
}

void
moblin_settings_brightness_shutdown (void)
{
	if(brightness_control.connection != NULL)
	{
		brightness_dbus_disconnect(&brightness_control);
		brightness_control.connection = NULL;
		brightness_control.proxy = NULL;
		brightness_control.udi = NULL;
		brightness_control.level = 0;
		brightness_control.brightness_changed_cb = NULL;
	}
}
