#ifndef PHP_MOD_BT_APACHE_H
#define PHP_MOD_BT_APACHE_H

/* hack for debian bug #378375:
 *
 * if WORDS_BIGENDIAN has already been defined, undefine it;
 * on big-endian architectures, including httpd.h will redefine it,
 * causing a compiler error.
 *
 * This has been seen on the IBM s390 arch.
 */
#ifdef WORDS_BIGENDIAN
#undef WORDS_BIGENDIAN
#endif

#include "httpd.h"
#include "http_config.h"
#include "http_core.h"

typedef struct php_struct {
    int state;
    request_rec *r;
    apr_bucket_brigade *brigade;
#if defined(NETWARE) && defined(CLIB_STAT_PATCH)
    struct stat_libc finfo;
#else
    struct stat finfo;
#endif
    int request_processed;
} php_struct;

#endif /* PHP_MOD_BT_APACHE_H */
