/*
 *  mod_bt - Making Things Better For Seeders
 *  Copyright 2004, 2005, 2006 Tyler MacDonald <tyler@yi.org>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#include <apr.h>
#include <apr_pools.h>

#include <strings.h>
#include <string.h>
#include <db.h>

#include <libbtutil/const.h>

#include <libbttracker/txn.h>
#include <libbttracker/types/btt_tracker.h>
#include <libbttracker/types/btt_infohash.h>

int btt_txn_register_hash(
    btt_tracker* tracker, apr_pool_t* p, DB_TXN* txn, const char* infohash,
    const char* filename, const bt_size_t filesize
) {
    DBT hash_key;
    DBT hash_val; 
    DBC* hash_cur = NULL;
    btt_infohash* hash = NULL;
    int ret = 0;

    bzero(&hash_key, sizeof(hash_key));
    bzero(&hash_val, sizeof(hash_val));

    hash_key.data = apr_palloc(p, BT_INFOHASH_LEN);
    hash_key.ulen = BT_INFOHASH_LEN;
    hash_key.size = BT_INFOHASH_LEN;
    hash_key.flags = DB_DBT_USERMEM;
    memcpy(hash_key.data, infohash, BT_INFOHASH_LEN);
 
    hash_val.data = apr_palloc(p, sizeof(btt_infohash));
    hash_val.ulen = sizeof(btt_infohash);
    hash_val.flags = DB_DBT_USERMEM;
 
    if(
        (ret = btt_txn_load_hashcursor(
            tracker, p, txn, &hash_key, &hash_val, &hash_cur,
            BTT_WRITE_CURSOR(tracker), DB_RMW, 1
        ))
        != 0
    ) {
        tracker->db.hashes->err(
            tracker->db.hashes, ret,
            "bt_txn_register_hash(): bt_txn_load_hashcursor()"
        );
        return ret;
    }

    hash = hash_val.data;
    hash->register_t = hash->last_t = tracker->s->server_time;
 
    if(filename && *filename) {
        BT_STRCPY(hash->filename, filename);
        hash->filename[BT_FILE_LEN] = 0;
    }
 
    if(filesize)
        hash->filesize = filesize;
 
    if(
        (ret = hash_cur->c_put(
            hash_cur, &hash_key, &hash_val, DB_CURRENT
        ))
        != 0
    )
        tracker->db.hashes->err(
            tracker->db.hashes, ret,
            "bt_txn_register_hash(): hash_cur->c_put()"
        );
  
    hash_cur->c_close(hash_cur);
    return ret;
}
