#ifndef LIBBTTRACKER_TYPES_BTT_TRACKER_H
#define LIBBTTRACKER_TYPES_BTT_TRACKER_H

/* libc */
#include <sys/types.h>
#include <time.h>
#include <unistd.h>
#include <string.h>
#include <stdint.h>
/* other libs */
#include <db.h>
#include <apr.h>
#include <apr_pools.h>
#include <apr_shm.h>
#include <apr_file_io.h>
#include <apr_file_info.h>
/* local */
#include <libbtutil.h>
#include <libbttracker/types/btt_db.h>

/* flags are documented at the top of bt_tracker.c */
#define BTT_TRACKER_REQUIRE_REG                 0x0001
#define BTT_TRACKER_ALLOW_SCRAPE_FULL           0x0002
#define BTT_TRACKER_ALLOW_SCRAPE_VERBOSE        0x0004
#define BTT_TRACKER_ALLOW_SCRAPE_XML            0x0008
#define BTT_TRACKER_ALLOW_SCRAPE_GENERAL        0x0010
#define BTT_TRACKER_BTREE                       0x0040

typedef struct btt_tracker_config_s {
    char        stylesheet[BT_PATH_LEN];
    char        db_dir[BT_PATH_LEN];
    char        detail_url[BT_PATH_LEN];
    char        root_include[BT_PATH_LEN];
    uint16_t    flags;
    uint32_t    random_retry;   /* not currenly used */
    uint32_t    return_peers;
    uint32_t    return_max;
    time_t      return_interval;
    uint32_t    return_peer_factor;
    uint32_t    hash_watermark;
    time_t      hash_min_age;
    time_t      hash_max_age;
    char*       parent_server;
} btt_tracker_config;

typedef struct btt_tracker_stats_s {
    uint32_t            num_children;
    uint32_t            num_requests;
    uint32_t            num_hashes;
    uint32_t            num_peers;
    uint64_t            announces;
    uint64_t            scrapes;
    uint64_t            full_scrapes;
    uint64_t            bad_announces;
    uint64_t            bad_scrapes;
    time_t              start_t;
    pid_t               master_pid;
    time_t              server_time;
    unsigned char       panic;
} btt_tracker_stats;

typedef struct btt_tracker_s {
    apr_shm_t*          m;      /*memory*/
    btt_db              db;
    apr_pool_t*		p;      /*pool*/
    btt_tracker_config*	c;      /*config*/
    btt_tracker_stats*	s;      /*stats*/
    unsigned char       myapr;  /*did we initialize APR?*/
    apr_file_t*         shlock; /*open lockfile*/
    char*               homedir;
} btt_tracker;

typedef struct btt_tracker_flag_s {
    unsigned char       flag;
    char*               description;
    char*               config_name;
} btt_tracker_flag;

/* used by Net::BitTorrent::LibBT::Tracker and Apache2::ModBT */
typedef struct btt_perltracker_s {
    int                 master;
    btt_tracker*        tracker;
    apr_pool_t*         p;
} btt_perltracker;

typedef struct btt_perltracker_s* Net__BitTorrent__LibBT__Tracker;

extern char btt_error_msg[BT_SHORT_STRING];

extern const btt_tracker_flag btt_tracker_flags[];
extern const btt_tracker_config new_btt_tracker_config;
extern const btt_tracker_stats new_btt_tracker_stats;
extern const btt_tracker new_btt_tracker;

extern int btt_tracker2xml(apr_pool_t* p, btt_tracker* tracker, char** result);
extern int btt_tracker2info_trs(
    apr_pool_t* p, btt_tracker* tracker, char** result
);

#define BTT_WRITE_CURSOR(t)	0

#endif /* LIBBTTRACKER_TYPES_BTT_TRACKER_H */
