/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: generate.c,v 1.5 2002/10/23 15:05:36 le_zas Exp $
*/

#include <libintl.h>
#include <locale.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <math.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <errno.h>


#include "mconfig.h"
#include "mstate.h"
#include "mlocale.h"
#include "mhash.h"
#include "mlist.h"
#include "mdatatypes.h"
#include "mplugins.h"

#include "plugin_config.h"

static int generate_history_output(mconfig *ext_conf, mlist *history) {
	return -1;
}

static int generate_monthly_output(mconfig * ext_conf, mstate * state) {
	return -1;
}

int mplugins_output_generate_monthly_output(mconfig *ext_conf, mstate *state, const char *subpath) {
	FILE *f = NULL;
	char filename[255];
	int ret;

	if (!mplugins_output_skeleton_patch_config(ext_conf)) {
		M_DEBUG0(ext_conf->debug_level, M_DEBUG_SECTION_PARSING, M_DEBUG_LEVEL_ERRORS,
			 "could not patch config\n");
		return -1;
	}

	if (subpath) {
		char *s;
		config_output *conf = ext_conf->plugin_conf;
		/* create the subdir if neccesary */

		s = malloc(strlen(subpath) + strlen(conf->outputdir) + strlen("//"));
		sprintf(s, "%s/%s/",
			conf->outputdir,
			subpath);
		if (-1 == mkdir(s, 0755)) {
			if (errno != EEXIST) {
				M_DEBUG1(ext_conf->debug_level, M_DEBUG_SECTION_PARSING, M_DEBUG_LEVEL_ERRORS,
					 "mkdir failed: %s\n", strerror(errno));
				return -1;
			}
		}

		/* modify output directory */
		free(conf->outputdir);
		conf->outputdir = s;

		fprintf(stderr, "generating output in %s\n", conf->outputdir);
	}

	if ((ret = generate_monthly_output(ext_conf, state))) {
		M_DEBUG0(ext_conf->debug_level, M_DEBUG_SECTION_PARSING, M_DEBUG_LEVEL_ERRORS,
			 "generate_monthly_output failed\n");
	}

	if (!mplugins_output_skeleton_unpatch_config(ext_conf)) {
		M_DEBUG0(ext_conf->debug_level, M_DEBUG_SECTION_PARSING, M_DEBUG_LEVEL_ERRORS,
			 "could not un-patch config\n");
		return -1;
	}

	return 0;
}

int mplugins_output_generate_history_output(mconfig *ext_conf, mlist *history, const char *subpath) {
	FILE *f;
	char filename[255];
	int ret;

	if (!mplugins_output_skeleton_patch_config(ext_conf)) {
		M_DEBUG0(ext_conf->debug_level, M_DEBUG_SECTION_PARSING, M_DEBUG_LEVEL_ERRORS,
			 "could not patch config\n");
		return -1;
	}

	if (subpath) {
		char *s;
		config_output *conf = ext_conf->plugin_conf;
		/* create the subdir if neccesary */

		s = malloc(strlen(subpath) + strlen(conf->outputdir) + strlen("//"));
		sprintf(s, "%s/%s/",
			conf->outputdir,
			subpath);

		if (-1 == mkdir(s, 0755)) {
			if (errno != EEXIST) {
				M_DEBUG1(ext_conf->debug_level, M_DEBUG_SECTION_PARSING, M_DEBUG_LEVEL_ERRORS,
					 "mkdir failed: %s\n", strerror(errno));
				return -1;
			}
		}

		/* modify output directory */
		free(conf->outputdir);
		conf->outputdir = s;

		fprintf(stderr, "generating history in %s\n", conf->outputdir);
	}

	ret = generate_history_output(ext_conf, history);

	if (!mplugins_output_skeleton_unpatch_config(ext_conf)) {
		M_DEBUG0(ext_conf->debug_level, M_DEBUG_SECTION_PARSING, M_DEBUG_LEVEL_ERRORS,
			 "could not un-patch config\n");
		return -1;
	}

	return 0;
}
